#ifndef lint
static char *RCSid = "$Header: star.c,v 1.13 89/08/04 20:10:39 jeffw Exp $";
#endif /* not lint */

/*
 * star.c
 *
 * do a starvation report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"
#include <math.h>
#include "item.h"

static	star_hdr();

starve()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	s_char	dirstr[20];
	int	vec[I_MAX+1], s;
	extern	int etu_per_update;

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	dirstr[0] = '.';
	dirstr[7] = '$';
	dirstr[8] = '\0';
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {

		if (!owner)
			continue;

		if (sect.sct_type == SCT_SANCT)
			continue;

		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		s = feed_people(vec, etu_per_update);

		if (s==0)
			continue;
		if (nsect++ == 0)
			star_hdr();
		if (god)
			pr(fmt("%3d ", sect.sct_own));
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[sect.sct_type].d_mnem));
		if (sect.sct_newtype != sect.sct_type)
			pr(fmt("%c", dchr[sect.sct_newtype].d_mnem));
		else
			pr(" ");
		pr(fmt("%4d%%", sect.sct_effic));
		pr(fmt(" will starve %d people\n",s));
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}

static
star_hdr()
{
	if (god)
		pr("    ");
	pr("CENSUS                   \n");
	if (god)
		pr("own ");
	pr("  sect        eff ");
	pr("\n");
}


/*
 * returns the number who starved, if any.
 */
int
feed_people(vec, etus)
	register int *vec;
	int	etus;
{
#ifndef	NOFOOD
	extern	double eatrate;
	double	food_eaten;
	double	people_left;
	int	can_eat;
	int	total_people;
	int	to_starve;
	int	starved;

	food_eaten = (etus * eatrate) *
		(vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW]);
	if (food_eaten <= 1)
		return 0;
	starved = 0;
	if (food_eaten > vec[I_FOOD]) {
#ifdef NEW_STARVE
		can_eat = (vec[I_FOOD] / (etus * eatrate));
		total_people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];

		/* only want to starve off at most 1/2 the populace. */
		if (can_eat < (total_people/2))
			can_eat = total_people/2;

		to_starve = total_people - can_eat;	
		while(to_starve && vec[I_UW]){
			to_starve--;
			starved++;
			vec[I_UW]--;
		}
		while(to_starve && vec[I_CIVIL]){
			to_starve--;
			starved++;
			vec[I_CIVIL]--;
		}
		while(to_starve && vec[I_MILIT]){
			to_starve--;
			starved++;
			vec[I_MILIT]--;
		}
		
		vec[I_FOOD] = 0;
#else
		people_left = (vec[I_FOOD] + 0.01) / (food_eaten + 0.01);
		starved = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
		/* only want to starve off at most 1/2 the populace. */
		if (people_left < 0.5)
			people_left = 0.5;
		vec[I_CIVIL] = (int) (vec[I_CIVIL] * people_left);
		vec[I_MILIT] = (int) (vec[I_MILIT] * people_left);
		vec[I_UW] = (int) (vec[I_UW] * people_left);
		starved -= vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
		vec[I_FOOD] = 0;
#endif /* NEW_STARVE */
	} else {
		vec[I_FOOD] -= roundavg(food_eaten);
	}
	return starved;
#else
	return 0;
#endif	NOFOOD
}
