#ifndef lint
static char *RCSid = "$Header: /users/empire/EMP/empmain/COMS/RCS/shi.c,v 1.10 89/07/02 21:03:38 mr-frog Exp $";
#endif /* not lint */

/*
 * miss.c
 *
 * missions for planes/ships/units
 *
 * --ts, Dec 1992
 */

#include "options.h"
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "retreat.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "path.h"
#include "mission.h"
#include "genitem.h"

/*
 *  mission <type> <planes/ships/units> <mission type> <op sector> [<radius>]
 */

mission()
{
	extern	s_char *argp[];
	s_char	*p;
	int	type;
	int	mission;
	coord	x, y;
	int	size, desired_radius, radius;
	struct	sctstr opsect;
	s_char	*block;
	struct	genitem *gp;
	int	num=0, mobmax, mobused, dist;
	struct	nstr_item ni;
	extern	int ship_mob_max;
	extern	int land_mob_max;
	extern	int plane_mob_max;
	s_char	*nameofitem();
	s_char	*mission_name();

	if ((p = getstarg(argp[1], "Ship, plane or land unit (p,sh,la)? ")) == 0)
		return RET_SYN;
	type = ef_byname(p);
	if (type != EF_SHIP && type != EF_LAND && type != EF_PLANE){
		pr("Planes, ships or land units only (p,sh,la)!\n" );
		return RET_SYN;
	}

	p = argp[2] = getstarg(argp[2], fmt("%s(s)? ",ef_nameof(type)));
	if (!snxtitem(&ni, type, argp[2]))
		return RET_SYN;

	if ((p = getstarg(argp[3], "Mission (int, sup, esc, res, air, query, clear)? ")) == 0)
		return RET_SYN;

/* 
 * 'i'     interdiction
 * 's'     support
 * 'e'     escort
 * 'r'     defensive reserve
 * 'a'     air defense (intercepts)
 */
	switch(*p){
		case 'I':
		case 'i': mission = MI_INTERDICT; break;
		case 'S':
		case 's': mission = MI_SUPPORT; break;
		case 'C':
		case 'c': mission = 0; break;
		case 'E':
		case 'e': mission = MI_ESCORT; break;
		case 'R':
		case 'r': mission = MI_RESERVE; break;
		case 'A':
		case 'a': mission = MI_AIR_DEFENSE; break;
		case 'q': show_mission(type,&ni);
                          return RET_OK;
		default:  pr(fmt("bad condition\n"));
		          pr(fmt("i\tinterdiction (any)\n"));
			  pr(fmt("s\tsupport (planes only)\n"));
			  pr(fmt("r\treserve (land units only)\n"));
			  pr(fmt("e\tescort (planes only)\n"));
			  pr(fmt("a\tair defense\n"));
			  pr(fmt("c\tclear mission\n"));
			  pr(fmt("q\tquery\n"));
		          return RET_SYN;
	}

	if (mission && !cando(mission,type)){
		pr(fmt("A %s cannot do that mission!\n",ef_nameof(type)));
		pr(fmt("i\tinterdiction (any)\n"));
		pr(fmt("s\tsupport (planes only)\n"));
		pr(fmt("r\treserve (land units only)\n"));
		pr(fmt("e\tescort (planes only)\n"));
		pr(fmt("a\tair defense (planes only)\n"));
		return RET_FAIL;
	}

	if (mission && ((mission != MI_RESERVE) && (mission != MI_ESCORT))){
		if ((p=getstarg(argp[4],"operations point? ")) == 0 || *p == 0)
			return RET_SYN;

		if (*p != '.'){
			if (!sarg_xy(p, &x, &y))
				return RET_SYN;

			if (!getsect(x, y, &opsect))
				return RET_FAIL;
		}
	}else{
		x=0;
		y=0;
	}

	if (argp[5] != (s_char *)0){
		desired_radius = atoi(argp[5]);
		if (desired_radius < 0){
			pr("Radius must be greater than zero!\n");
			return RET_FAIL;
		}
	}

	size = max(sizeof(struct lndstr),sizeof(struct plnstr));
	size = max(size,sizeof(struct shpstr));
	block = malloc(size);
	switch (type){
		case EF_SHIP:	mobmax = ship_mob_max; break;
		case EF_LAND:	mobmax = land_mob_max; break;
		case EF_PLANE:	mobmax = plane_mob_max; break;
	}

	mobused = ldround(((double)mobmax/2.0),1);

	while (nxtitem(&ni, block)) {
		gp = (struct genitem *)block;

		if (!owner || gp->own == 0)
			continue;

		if (mission && (gp->mobil < mobused)){
			pr(fmt("%s #%d: not enough mobility! (needs %d)\n",
				ef_nameof(type), gp->uid, mobused));
			continue;
		}
		if (*p == '.'){
			x = gp->x;
			y = gp->y;
			if (!getsect(x, y, &opsect))
				return RET_FAIL;
		}

		dist = mapdist(gp->x, gp->y, x, y);
		radius = 999;
		if ((mission == MI_INTERDICT || mission == MI_SUPPORT ||
			mission == MI_AIR_DEFENSE) &&
			(oprange(gp,type,x,y,&radius) < dist)){
			pr(fmt("%s #%d: out of range! (range %d)\n",
				ef_nameof(type), gp->uid,
				oprange(gp,x,y,type)));
			continue;
		}

		if (radius > desired_radius)
			radius = desired_radius;

		if (mission && (gp->effic < 60)){
			pr(fmt("%s #%d: not efficient enough! (must be>=60%)\n",
				ef_nameof(type), gp->uid));
			continue;
		}

		if ((mission == MI_INTERDICT) && (type == EF_SHIP))
			if (mchr[gp->type].m_frnge < 1){
				pr(fmt("%s #%d: cannot fire at range!\n",
					ef_nameof(type), gp->uid));
				continue;
			}

		if ((mission == MI_INTERDICT) && (type == EF_LAND))
			if (lchr[gp->type].l_frg < 1){
				pr(fmt("%s #%d: cannot fire at range!\n",
					ef_nameof(type), gp->uid));
				continue;
			}

		if ((mission == MI_INTERDICT) && (type == EF_PLANE)){
			struct plchrstr *pcp;

			pcp = &plchr[gp->type];
			if (!(pcp->pl_flags & P_T)){
				pr(fmt("Only planes with the tactical ability can interdict.\n%s #%d is ineligible\n", pcp->pl_name,gp->uid));
				continue;
			}
		}

		if ((mission == MI_AIR_DEFENSE) && (type == EF_PLANE)){
			struct plchrstr *pcp;

			pcp = &plchr[gp->type];
			if (!(pcp->pl_flags & P_F)){
				pr(fmt("Only planes with the intercept abilities can perform air defense.\n%s #%d is ineligible\n", pcp->pl_name,gp->uid));
				continue;
			}
		}

		if ((mission == MI_ESCORT) && (type == EF_PLANE)){
			struct plchrstr *pcp;

			pcp = &plchr[gp->type];
			if (!(pcp->pl_flags & P_ESC) && !(pcp->pl_flags & P_F)){
				pr(fmt("Only planes with the escort or intercept abilities can escort.\n%s #%d is ineligible\n", pcp->pl_name,gp->uid));
				continue;
			}
		}

		if ((mission == MI_SUPPORT) && (type == EF_PLANE)){
			struct plchrstr *pcp;

			pcp = &plchr[gp->type];
			if (!(pcp->pl_flags & P_T)){
				pr(fmt("Only planes with the tactical ability can support.\n%s #%d is ineligible\n", pcp->pl_name,gp->uid));
				continue;
			}
		}

		num++; /* good one.. go with it */

		if (mission == MI_INTERDICT || mission == MI_SUPPORT ||
			mission == MI_AIR_DEFENSE)
			gp->radius = radius;
		else
			gp->radius = 0;

		if (mission == MI_SUPPORT || mission == MI_INTERDICT ||
			mission == MI_AIR_DEFENSE)
			pr(fmt("%s on %s mission, centered on %s, radius %d\n",
				nameofitem(gp,type), mission_name(mission),
				xyas(x,y,cnum), gp->radius));
		else if (mission)
			pr(fmt("%s on %s mission\n",
				nameofitem(gp,type), mission_name(mission)));

		if (mission)
			gp->mobil -= mobused;
		gp->mission = mission;
		gp->opx = x;
		gp->opy = y;
		switch (type){
			case EF_SHIP:
				putship(gp->uid,block);
				break;
			case EF_LAND:
				putland(gp->uid,block);
				break;
			case EF_PLANE:
				putplane(gp->uid,block);
				break;
		}
	}
	if (num == 0) {
		pr(fmt("No %s%s\n", ef_nameof(type), splur(num)));
		return RET_FAIL;
	}
	pr(fmt("%d %s%s\n", num, ef_nameof(type), splur(num)));
	return RET_OK;
}
