#ifndef lint
static char *RCSid = "$Header: conv.c,v 1.8 90/03/19 11:08:30 mr-frog Exp $";
#endif /* not lint */

/*
 * conv.c
 *
 * Convert conquered populace into uw's.
 *
 * Pay $1.5 per civ converted (reg fees), as well as 1 btu/100
 * in paper shuffling.  Also 1 mobility point/5 convertees.
 *
 * Dave Pare, 1986
 */

/*
 * format: convert <SECTS> <NUMBER PER SECTOR>
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "land.h"

conv()
{
	extern s_char *argp[];
	struct sctstr sect;
	struct nstr_sect nstr;
	int uwtoconvert, newuw, totaluw, uw;
	int civ, mil, adj_mob, mob, btused, cost;
	double security_extra=1.0;
	struct lndstr land;
	struct nstr_item ni;

	if (snxtsct(&nstr, argp[1]) == 0)
		return RET_SYN;
	uwtoconvert = onearg(argp[2], "Number to convert: ");
	if (uwtoconvert < 0)
		return RET_SYN;
	totaluw = cost = btused = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (sect.sct_oldown == cnum)
			continue;
		civ = getvar(V_CIVIL, (s_char *)&sect, EF_SECTOR);
		if (civ == 0)
			continue;
		mil = getvar(V_MILIT, (s_char *)&sect, EF_SECTOR);

		/*
		 * Military units count according to the number of
		 * mil in them. (i.e. attack/defense modified don't
		 * count.
		 */
		snxtitem_xy(&ni, EF_LAND, sect.sct_x, sect.sct_y);
		while (nxtitem(&ni, (s_char *)&land)){
			mil += (lchr[land.lnd_type].l_mil *
				((double)land.lnd_effic/100.0));

			/* Anti-terrorist units count double */
			if (lchr[land.lnd_type].l_flags & L_SECURITY){

				/*
				 * They also increase the efficiency of
				 * the conversion process by 10% each.
				 * (but they use 10 mobility doing it)
				 */
				security_extra += .1;
				land.lnd_mobil -= 10;
				putland(land.lnd_uid,&land);
				mil += (lchr[land.lnd_type].l_mil *
					((double)land.lnd_effic/100.0));
			}
		}
		/*
		 * Must have military control to convert captured civs.
		 */
		if (mil * 10 < civ)
			continue;
		newuw = civ;
		if (newuw > uwtoconvert)
			newuw = uwtoconvert;
		uw = getvar(V_UW, (s_char *)&sect, EF_SECTOR);
		if (uw > 999)
			continue;
		if (newuw > 999 - uw)
			newuw = 999 - uw;
		if (newuw == 0)
			continue;
		/*
		 * So entire civilian populations don't disappear immediately
		 * into re-education camps, charge a healthy mobility cost for
		 * conversions.
		 */
		mob = sect.sct_mobil * 5;

		/* security troops make conversion more effective */
		adj_mob = ldround(((double)mob*security_extra),1);

		if (adj_mob < newuw)
			newuw = adj_mob;
		if (newuw == 0)
			continue;
		if (newuw < mob)
			mob = newuw;
		if (putvar(V_UW, newuw + uw, (s_char *)&sect, EF_SECTOR) == 0) {
			pr(fmt("No room for new uw in %s\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
			continue;
		}
		civ -= newuw;
		putvar(V_CIVIL, civ, (s_char *)&sect, EF_SECTOR);
		sect.sct_mobil -= roundavg(mob * 0.2);
		pr(fmt("%3d conquered civilians converted in %s (%d)\n",
			newuw, xyas(sect.sct_x, sect.sct_y, cnum),
			uw + newuw));
		if (civ == 0) {
			sect.sct_oldown = sect.sct_own;
			pr(fmt("%s is now completely yours.\n",
				xyas(sect.sct_x, sect.sct_y, cnum)));
		}
		putsect(&sect);
		btused += (newuw - 1) / 100 + 1;
		cost += (int) (newuw * 1.5);
		totaluw += newuw;
	}
	NAT_DELTA(nat_btu, cnum, -btused);
	NAT_DELTA(nat_money, cnum, -cost);
	pr(fmt("Total civilians converted: %d\n", totaluw));
	pr(fmt("Paperwork at conversion places ... %d\n", btused));
	return RET_OK;
}
