#ifndef lint
static char *RCSid = "$Header: comm.c,v 1.9 89/08/04 20:14:14 jeffw Exp $";
#endif /* not lint */

/*
 * comm.c
 *
 * do a commodity report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "path.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

static	prthresh();

comm()
{
	extern	s_char *argp[];
	struct	sctstr sect;
	s_char	dirstr[12];
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	int	del[I_MAX+1];
	int	dist[I_MAX+1];
	int	item[I_MAX+1];

	if (!snxtsct(&nstr, argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!owner)
			continue;
		if (nsect++ == 0) {
			if (god)
				pr("   ");
			pr("COMMODITIES deliver--  distribute\n");
			if (god)
				pr("   ");
			pr("  sect      sgpidbolhr sgpidbolhr  sh gun  pet iron dust bar  oil  lcm  hcm rad\n");
		}
		if (god)
			pr(fmt("%3d", sect.sct_own));
		getvec(VT_DEL, del, (s_char *)&sect, EF_SECTOR);
		getvec(VT_DIST, dist, (s_char *)&sect, EF_SECTOR);
		getvec(VT_ITEM, item, (s_char *)&sect, EF_SECTOR);
		pr(xyfmt("%4d,%-4d", nstr.x, nstr.y, cnum));
		pr(fmt(" %c", dchr[sect.sct_type].d_mnem));
		pr(fmt(" %c", dirstr[del[I_SHELL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_GUN] & 0x7]));
		pr(fmt("%c", dirstr[del[I_PETROL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_IRON] & 0x7]));
		pr(fmt("%c", dirstr[del[I_DUST] & 0x7]));
		pr(fmt("%c", dirstr[del[I_BAR] & 0x7]));
		pr(fmt("%c", dirstr[del[I_OIL] & 0x7]));
		pr(fmt("%c", dirstr[del[I_LCM] & 0x7]));
		pr(fmt("%c", dirstr[del[I_HCM] & 0x7]));
		pr(fmt("%c", dirstr[del[I_RAD] & 0x7]));
		prthresh(" %c", dist[I_SHELL]);
		prthresh("%c", dist[I_GUN]);
		prthresh("%c", dist[I_PETROL]);
		prthresh("%c", dist[I_IRON]);
		prthresh("%c", dist[I_DUST]);
		prthresh("%c", dist[I_BAR]);
		prthresh("%c", dist[I_OIL]);
		prthresh("%c", dist[I_LCM]);
		prthresh("%c", dist[I_HCM]);
		prthresh("%c", dist[I_RAD]);
		pr(fmt("%4d", item[I_SHELL]));
		pr(fmt("%4d", item[I_GUN]));
		pr(fmt("%5d", item[I_PETROL]));
		pr(fmt("%5d", item[I_IRON]));
		pr(fmt("%5d", item[I_DUST]));
		pr(fmt("%4d", item[I_BAR]));
		pr(fmt("%5d", item[I_OIL]));
		pr(fmt("%5d", item[I_LCM]));
		pr(fmt("%5d", item[I_HCM]));
		pr(fmt("%4d", item[I_RAD]));
		pr("\n");
	}
	if (nsect == 0) {
		if (argp[1])
			pr(fmt("%s: No sector(s)\n", argp[1]));
		else
			pr(fmt("%s: No sector(s)\n", ""));
		return RET_FAIL;
	}else
		pr(fmt("%d sector%s\n", nsect, splur(nsect)));
	return 0;
}

static
prthresh(format, val)
	s_char	*format;
	int	val;
{
	if (val >= 1000)
		val = 'a';
	else if (val > 0)
		val = val / 100 + '0';
	else
		val = '.';
	pr(fmt(format, val));
}
