#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/empmain/COMS/RCS/carg.c,v 1.7 89/07/30 08:24:32 jeffw Exp $";
#endif /* not lint */

/*
 * carg.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "ship.h"
#include "land.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

carg()
{
	extern	s_char *argp[];
	int	nships;
	struct	nstr_item ni;
	struct	shpstr ship;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_SHIP, argp[1]))
		return RET_SYN;
	nships = 0;
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_own == 0)
			continue;
		if ((cnum != ship.shp_own) && !god)
			continue;
		if (ship.shp_type < 0 || ship.shp_type > shp_maxno) {
			pr(fmt("bad ship type %d (#%d)\n", ship.shp_type,
			       ni.cur));
			continue;
		}
		if (nships++ == 0)
			pr("shp# ship type           x,y   flt  eff  sh gun pet irn dst bar oil lcm hcm rad\n");
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", mchr[ship.shp_type].m_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", ship.shp_x, ship.shp_y, cnum)));
		pr(fmt(" %1c", ship.shp_fleet));
		pr(fmt("%4d%%", ship.shp_effic));
		getvec(VT_ITEM, vec, (s_char *)&ship, EF_SHIP);
		pr(fmt("%4d", vec[I_SHELL]));
		pr(fmt("%4d", vec[I_GUN]));
		pr(fmt("%4d", vec[I_PETROL]));
		pr(fmt("%4d", vec[I_IRON]));
		pr(fmt("%4d", vec[I_DUST]));
		pr(fmt("%4d", vec[I_BAR]));
		pr(fmt("%4d", vec[I_OIL]));
		pr(fmt("%4d", vec[I_LCM]));
		pr(fmt("%4d", vec[I_HCM]));
		pr(fmt("%4d\n", vec[I_RAD]));
#ifdef	SHIPNAMES
		if (ship.shp_name[0] != 0) {
			pr(fmt("       %s\n",ship.shp_name));
		}
#endif	SHIPNAMES
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr("No ship(s)\n");
	}
	if (nships == 0) {
		if (argp[1])
			pr(fmt("%s: No ship(s)\n", argp[1]));
		else
			pr(fmt("%s: No ship(s)\n", ""));
		return RET_FAIL;
	}else
       		pr(fmt("%d ship%s\n", nships, splur(nships)));
	return RET_OK;
}

lcarg()
{
	extern	s_char *argp[];
	int	nunits;
	struct	nstr_item ni;
	struct	lndstr land;
	int	vec[I_MAX+1];

	if (!snxtitem(&ni, EF_LAND, argp[1]))
		return RET_SYN;
	nunits = 0;
	while (nxtitem(&ni, (s_char *)&land)) {
		if ((cnum != land.lnd_own) && !god)
			continue;
		if (land.lnd_type < 0 || land.lnd_type > shp_maxno) {
			pr(fmt("bad unit type %d (#%d)\n", land.lnd_type,
			       ni.cur));
			continue;
		}
		if (nunits++ == 0)
			pr("lnd# unit type           x,y    a   eff  sh gun pet irn dst bar oil lcm hcm rad\n");
		pr(fmt("%4d ", ni.cur));
		pr(fmt("%-16.16s ", lchr[land.lnd_type].l_name));
		pr(fmt("%s ", xyfmt("%4d,%-4d", land.lnd_x, land.lnd_y, cnum)));
		pr(fmt(" %1c", land.lnd_army));
		pr(fmt("%4d%%", land.lnd_effic));
		getvec(VT_ITEM, vec, (s_char *)&land, EF_LAND);
		pr(fmt("%4d", vec[I_SHELL]));
		pr(fmt("%4d", vec[I_GUN]));
		pr(fmt("%4d", vec[I_PETROL]));
		pr(fmt("%4d", vec[I_IRON]));
		pr(fmt("%4d", vec[I_DUST]));
		pr(fmt("%4d", vec[I_BAR]));
		pr(fmt("%4d", vec[I_OIL]));
		pr(fmt("%4d", vec[I_LCM]));
		pr(fmt("%4d", vec[I_HCM]));
		pr(fmt("%4d\n", vec[I_RAD]));
	}
	if (nunits == 0) {
		if (argp[1])
			pr(fmt("%s: No unit(s)\n", argp[1]));
                else
			pr("No unit(s)\n");
		return RET_FAIL;
	}else
		pr(fmt("%d unit%s\n", nunits, splur(nunits)));
	return RET_OK;
}
