.TH Concept "Train Types"
Trains provide a convenient means of transporting large
quantities of goods across land.  The difference between
using trains (or other vehicles) and the \*Qmove\*U and
\*Qtransport\*U commands is that trains can be moved across 
foreign soil.  Trains are therefore a land alternative
to using ships, for example, to move goods in a game that
uses trade center markets.  
.s3
The train types currently available in Empire are:
.s3
.NF +8
passenger
freight
munitions
express
.FI
.s1
These train types differ in their fundamental capabilities;
some trains are faster than others, some are equipped to carry
many passengers, others are equipped to carry freight, etc.
The capabilities of each train are given by 
the \*Qshow\*U command.  The headings are as follows. For 
the building data:
.s3
.in \w'tech\0\0'u
.L lcm
The lcm required to build the train.
.L hcm
The hcm required to build the train.
.L avail
The available workforce needed to build the train.
.L tech
The minimum technology required to build the train.
.L $
The cost of the train.
.in \\n(in
.s1
The headings for the capability listing are
.s1
.in \w'fir\0\0'u
.L def
defensive armament of the train
.L spd
the distance/mu for moving (in relative units)
.L vis
how visible the train is, (relative units)
.L spy
how far the train can see, (i.e. how good the
communication equipment is), again in relative units
.L rng
twice the distance the guns can fire,
(assuming a high technology level)
.L fir
the number of guns the train can fire at once
.L mpg
the train's fuel efficiency factor
.L tnk
number of vehicles the train can transport
.L pln
number of planes/missiles the train can carry
.in
.s3
Trains can be built, scrapped, and upgraded in tank farms
(sector type \*Qz\*U), are moved via the \*Qnavigate\*U command,
and are able to move only in highway, bridge head, bridge span,
tank farm, trade center, and warehouse sectors.  They can load
and unload in all but bridge spans.
.s3
Each train can carry a certain amount of products and has certain
capabilities. These are listed under the cargoes & abilities section.
The cargoes give the number of each product that can be carried.
The abilities are as follows.
.s1
.in \w'sonar\0\0'u
.L plane
The train can carry planes with the light attribute set.
.L miss
The train can carry missiles.
.L spy
The train can engage in spying activities.
.L pet
The train requires petrol as fuel.
.in
.s3
Some examples of the output:
.s1
.EX [3:248] Command : show train build
.NF
              lcm hcm avail tech  $
passenger      30  50    27    0 $1500
freight        30  50    27    0 $1500
munitions      30  50    27   10 $1500
express        40  40    25   30 $4500
.FI
.s3
.EX [12:248] Command : show train cap
.NF
              def spd vis spy rng fir mpg tnk pln cargoes & abilities
passenger      10  55  20   1   0   0  80   0   0 1400c 20m 300f 800u 200p
freight        10  55  20   1   0   0  60  40   4 10c 10m 5000f 4000l 2000h 10u
800o 800p
munitions      10  55  20   1   0   0  80   4   4 200m 2000s 500g 100f 300p
express        10  95  20   1   0   0  80   0   0 500c 40m 200f 200u 100p
.FI
.s3
See also : coastwatch, fire, load, lookout, navigate, tend, show
