.TH Command SHUTTLE
.SY "shuttle [<SHUTTLE/FLEET> | <SECTS>] [climb|descend <new-ALTITUDE>]"
The shuttle command is a census of your space shuttles and lists all the
info available in readable format.  The command also lets you make 
altitude changes for individual shuttles.
.s3
The <SHUTTLE/FLEET> and <SECTS> arguments let you look at one shuttle,
a fleet of shuttles, or all shuttles within a given area.
.s3
The [climb|descend] and <new-ALTITUDE> arguments lets you change a 
shuttle's altitude (which, in turn, changes its orbital velocity,
viewing distance, viewing accuracy, etc).  Just above the atmosphere
(which typically extends up to about altitude 32), a shuttle will move 
each update with an orbital velocity equal to the number of ETUs per 
update; at altitude 126, a shuttle has an orbital velocity of 1; altitude 
127 is a geosynchronous parking orbit.  Ascent beyond altitude 127 
is (currently) not possible.
.s3
Mobility cost of an altitude change is equal the distance ascended or 
descended.  Petrol cost varies: petrol burned in a climb is equal 
to the mobility cost; petrol burned in a descent is equal 
to 1/8 of the mobility cost.
.s3
To launch a shuttle, use the `\*Qlaunch shuttle\*U' command.
Once the shuttle is airborne, the `\*Qshuttle\*U' command is used to
make altitude changes or land, and the `\*Qnavigate\*U' command is used
to make position adjustments.
.s3
To land a shuttle, you must manually descend it down to altitude zero
(ground level) at an airfield.  Attempts to descend more than
ETU/2 units of altitude at any one time will be rejected (the 
vertical velocity would be too great, and the shuttle would burn
up in the atmosphere).  NOTE: An unattended shuttle shuttle that is
lower than altitude 127 will lose altitude at each update at an
increasing rate, and eventually will become toast.
.s3
To change a shuttle's direction of orbit once it's aloft, the shuttle
must first be at altitude 127.  Use the `\*Qnav\*U' command to
move the shuttle in the desired direction, and then descend the
shuttle to a lower altitude.  Although a shuttle at lower altitude
can be manually navigated in any direction, it will continue in its
orbital direction at the update.
.s3
Shuttle expects one or more arguments.  To see every shuttle you own,
give it the argument '*', or type "shuttle *".
.s3
The report format contains the following fields:
.s1
.in \w'shuttle type\0\0'u
.L shu#
the shuttle number
.L shuttle type
the type of shuttle (\*Qshuttle\*U, \*Qblimp\*U, \*Qairship\*U, etc)
.L x,y
the shuttle's current location (relative to your capital)
.L f/c
fleet and convoy designation letters (set by `\*Qfleetadd\*U' command)
.L eff
the shuttle's efficiency
.L alt
the shuttle's orbit vector and altitude
.L civ
civ is the number of civilians on board
.L mil
mil is the number of military on board
.L food
the amount of food on board
.L mob
the mobility of the shuttle
.L tech
the tech level of the shuttle
.L air
the amount of cabin air aboard
.L pet
the amount of petrol aboard
.in
.s1
For example:
.EX shuttle *
.NF
shu#   shuttle type      x,y    f/c  eff   orbit civ mil food mob  air pet
  22 space shuttle    -127,23       100%  18j/92   1   1    2  10 100%  24
1 shuttles

.FI
.EX shu 22 climb 94
.NF
space shuttle #22 climbing to altitude 94 in -127,23.
1 shuttle

.FI
.s3
See also : build, cargo, fleetadd, navigate, load, lookout, scrap, upgrade,
transport, shuttle-types
