.TH Command RDUMP
.SY "rdump <SHIP|SECTOR> [FILTERS]"
The `\*Qrdump\*U' command works exactly like the `\*Qradar\*U' 
command, but the radar map information is output in a compressed
format that is more suitable for input to an empire tool such
as \*Qve\*U.
.s1
In the syntax of the `rdump' command:
.NF

<SHIP|SECTOR>   is the ship, sector, range, or realm for which
		you want to create radar maps.  If sector(s)
		are specified, only radar stations will be used.

[FILTERS]	is an optional string of one or more radar
		information \*Qfilter\*U characters:

		n - do NOT show ...
		s - ships
		l - land & water
		z - trains
		p - planes
		t - tanks
		b - balloons
		a - everything

.FI
If no filters are specified, the default radar image showing
everything is dumped out.  A typical usage might be:
.s1
.EX rdump 17
.NF
RADAR DUMP
"nuclear carrier #17" 0 -50 88 66 5
5 -55 -17 ......
4 -56 -16 .......
3 -57 -15 ........
2 -58 -14 ...o.....
1 -59 -13 ........D.
0 -60 -12 ....h0^^^Ch
1 -59 -11 ....*.wcdb
2 -58 -10 ...)ij++l
3 -57 -9 ...^m^fk
4 -56 -8 .......
5 -55 -7 ......

.FI
The output contains the following information:
.NF

RADAR DUMP
"<radar site>" <owner> <x> <y> <efficiency> <range>
<offset> <row x> <row y> <radar data...>
<offset> <row x> <row y> <radar data...>
   ...
<blank line>

The header line contains six fields of information:

  <radar site>     is the place, ship or vehicle generating the report
  <owner>          is the country number that generated the report
  <x> <y>          is the radar site's location
  <efficiency>     is the radar site's efficiency
  <range>          is the radar site's effective range

Each subsequent row of the dump contains four fields of information:

  <offset>         is the number of blanks to print before printing
                   radar data (if you want to format the dump to look
                   like standard radar command output)

  <row x> <row y>  are the coordinates of the first radar data character

  <radar data...>  is a whitespace-terminated string of radar data
                   characters.  As you progress character by character
                   through the string, the x-coordinate increments by 2.
                   The radar site itself is marked by a `0' character.

Finally, the dump is terminated by a blank line.
.FI
.s3
See also : dump, pdump, vdump, sdump, odump
