.TH Command ODUMP
.SY "odump <SATELLITES> [FILTERS]"
The `\*Qodump\*U' (orbiter dump) command works exactly like the 
map-generating portion of the`\*Qsatellite\*U' command, but the 
map information is output in a compressed format that is more 
suitable for input to an empire tool such as \*Qve\*U.
.s1
In the syntax of the `odump' command:
.NF

<SATELLITES>    is the satellite for which you want to create
		a radar map.  If sector(s) are specified, only 
                satellites in those sectors(s) will be used.

[FILTERS]	is an optional string of one or more map
		information \*Qfilter\*U characters:

                s - ships
                l - land & water
                z - trains
                p - planes
                t - tanks
                b - balloons
                h - space shuttles
                a - everything

.FI
If no filters are specified, the default map image showing
everything is dumped out.  A typical usage might be:
.s1
.EX odump 76
.NF
[24:252] Command : odump 76 .
SATMAP DUMP
"spysat 2 (#76)" 7 63 25 100 10
10 53 15 ...........
9 52 16 ............
8 51 17 ............f
7 50 18 ..............
6 49 19 ...fk..........
5 48 20 .=hmmim=.......#
4 47 21 f)#++++#f........
3 46 22 .d*l+mcmh.........
2 45 23 ....j+j^k).........
1 44 24 .....#h.............
0 43 25 ......=..^0..........
1 44 26 ......a.............
2 45 27 ...................
3 46 28 ..................
4 47 29 .................
5 48 30 ................
6 49 31 ...............
7 50 32 =#............
8 51 33 .l)..........
9 52 34 .f..*.......
10 53 35 ...........

.FI
The output contains the following information:
.NF

SATMAP DUMP
"<satellite>" <owner> <x> <y> <efficiency> <range>
<offset> <row x> <row y> <map data...>
<offset> <row x> <row y> <map data...>
   ...
<blank line>

The header line contains six fields of information:

  <satellite>      is the satellite generating the report
  <owner>          is the country number that generated the report
  <x> <y>          is the satellite's location
  <efficiency>     is the satellite's efficiency
  <range>          is the satellite's effective range

Each subsequent row of the dump contains four fields of information:

  <offset>         is the number of blanks to print before printing
                   map data (if you want to format the dump to look
                   like standard satellite map command output)

  <row x> <row y>  are the coordinates of the first map data character

  <map data...>    is a whitespace-terminated string of map data
                   characters.  As you progress character by character
                   through the string, the x-coordinate increments by 2.
                   The satellite itself is marked by a `0' character.

Finally, the dump is terminated by a blank line.
.FI
.s3
See also : pdump, vdump, sdump, rdump
