.TH Command BALLOON
.SY "balloon [<BALLOON/FLEET> | <SECTS>] [climb|descend]"
The balloon report command is a census of your balloons and lists all the
info available in readable format.  The command also lets you control the
ascent and descent of individual balloons.
.s3
The <BALLOON/FLEET> and <SECTS> arguments are provided in case you only
wish to look at one balloon, or one fleet of balloons, or all balloons within
a given area.
.s3
The optional [climb|descend] argument lets you change a balloon's altitude.
In order to climb, each balloon must contain enough lighter-than-air gas
to be able to reach the next altitude level.  Use the `\*Qshow balloon
volume\*U' command to see required gas volumes.  Low altitude flight
can be maintained with 50% of the maximum amount of gas; high altitude
flight requires 75%.  At low altitude, gas volume slowly decreases with
each update.  At high altitude, the loss rate is twice as fast, and at
any altitude, the loss rate increases as balloon efficiency drops.
If gas volume drops below 50% of the maximum capacity, the balloon,
unable to sustain flight, will crash.
.s3
To launch a balloon, use the `\*Qlaunch balloon\*U' command.
Once the balloon is airborne, the `\*Qballoon\*U' command is used to
make altitude changes or land.
.s3
To replenish gas, you must land the balloon.  In any sector capable of 
building a balloon, the gas volume automatically increases with each update
at a rate equal to 100 times the number of elapsed etus times the sector
efficiency.  In other sectors, the rate is only half as fast; if you don't
own the sector, the rate is cut in half once more.
.s3
Balloons can usually land almost anywhere except in sanctuaries, wasteland,
mountains, bridgespans, and water.  You will be informed if a sector does 
not offer an suitable landing areas; harbors, airfields, and trade centers,
however, guarantee good landing sites.
.s3
Balloons can be loaded, unloaded, boarded, and tended only while they are on 
the ground.  Balloons can be loaded only in harbors, airports and trade
centers, but can be unloaded anywhere.  You use the `\*Qnav\*U' command to
move balloons once they are airborne.  `\*QRadar\*U' and `\*Qlook\*U' range 
increases with altitude, but at the price of increased visibility.
.s3
If you wish to move a balloon while it is on the ground, you can do so
by using the `transport' command.
.s3
Changes in altitude cost 1 mobility unit and normally require a crew.  The
only time that a crew is not needed is when you release an unmanned balloon.
Unmanned balloons are neither retrieveable nor navigable, and will fly over 
the same sector forever until they either lose too much gas or are shot down.
.s3
Balloon expects an argument.  To see every balloon you own, give it
the argument '*', or type "balloon *".
.s3
The report format contains the following fields:
.s1
.in \w'balloon type\0\0'u
.L bal#
the balloon number
.L balloon type
the type of balloon (\*Qballoon\*U, \*Qblimp\*U, \*Qairship\*U, etc)
.L x,y
the balloon's current location (relative to your capital)
.L f/c
fleet and convoy designation letters (set by `\*Qfleetadd\*U' command)
.L eff
the balloon's efficiency
.L alt
the balloon's altitude (land, low, or high)
.L civ
civ is the number of civilians on board
.L mil
mil is the number of military on board
.L food
the amount of food on board
.L mob
the mobility of the balloon
.L tech
the tech level of the balloon
.L gas
the volume of gas in the balloon's envelope
.in
.s1
For example:
.EX balloon *
.NF
bal#   balloon type      x,y    f/c  eff  alt civ  mil food mob tech  gas
   4 airship           -25,-11      100% land   0    5   50  51  146 4635
  22 balloon          -127,23       100%  low   1    1    2  10   55  770
 152 blimp              62,8        100% high   0    2   10  44   82 2245

3 balloons

.FI
.EX bal 4 climb
.NF
airship #4 climbing to low altitude in -25,-11.
1 balloon

.FI
.EX bal 4 climb
.NF
airship #4 climbing to high altitude in -25,-11.
1 balloon

.FI
.s3
See also : build, cargo, fleetadd, navigate, load, lookout, scrap, upgrade,
transport, balloon-types
