/*
 * xy.h
 *
 * constants having to do with locations
 *
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:28 $
 */

#ifndef HAVE_XY

#define HAVE_XY

typedef struct range {
    coord lx;	/* low-range x,y */
    coord ly;
    coord hx;	/* high-range x,y */
    coord hy;
    int width;	/* range width, height */
    int height;
} _range;

typedef struct locationstr {
    struct locationstr *next;	/* linked list 'next' pointer */
    struct locationstr *targ;	/* ptr to target location */
    struct sctstr *sect;	/* ptr to raw sector info */
    struct shpstr *ship;	/* ptr to raw ship info */
    coord x,y;			/* sector coordinates */
    natid own;			/* sector/ship owner */
    double range;		/* firing range */
    int elev;			/* sector elevation */
    int shots;			/* number of shells to fire */
    int guneff;			/* gun efficiency */
    int def;			/* defensive rating */
    int eff;			/* sector/ship efficiency */
    int guns;			/* number of guns in ship/sector */
    int shells;			/* number of shells in ship/sector */
    int mil;			/* number of mil in ship/sector */
} location;

extern	char *ownxy();
extern	char *xyas();
extern	char *xyfmt();

coord	xabnorm(), yabnorm();
coord	xnorm(), ynorm();
coord	xabs(), yabs();
coord	xrel(), yrel();

#endif
