/*
** update.h
**
** nation update status structure
*/

#define SM_BADPATH    0x01  /* bad dist path */
#define SM_OUTBREAK   0x02  /* outbreak of plague */
#define SM_BATTLING   0x04  /* battling plague */
#define SM_DEATHS     0x08  /* plague deaths reported */
#define SM_UNREST     0x10  /* civil unrest */
#define SM_FULLOWN    0x20  /* gained full ownership */
#define SM_SUBVERSION 0x40  /* revolutionary subversion */
#define SM_DISRUPT0   0x80  /* production disrupted (1/4) */
#define SM_DISRUPT1  0x100  /* production disrupted (2/4) */
#define SM_DISRUPT2  0x200  /* production disrupted (3/4) */
#define SM_DISRUPT3  0x400  /* production disrupted (4/4) */
#define SM_RETAKE    0x800  /* regained control */

struct worthstr {
    natid cn;
    long value;
};

struct statmapstr {
    u_char own;             /* sector owner */
    u_char backlog;         /* commodity in production backlog */
    short flags;            /* misc SM_ sector status flags (see above) */
};

struct statstr {
    int sects_total;        /* total sectors updated */
    int sects_noeffdelta;   /* num sectors that didn't gain eff */
    int sects_noproduce;    /* num sectors that didn't produce  */
    int sects_noprodmill;   /* num mill sectors that didn't produce */
    int sects_nodeliver;    /* num sectors that didn't deliver */
    int sects_onhold;       /* num sectors on production hold */
    int sects_buildup;      /* num sectors the gained eff */
    int sects_teardown;     /* num sectors that lost eff */
    int cost_buildup;       /* money spent building up sectors */
    int cost_teardown;      /* money spent dismantling sectors */
    int	high_tech;
    long money;
    long pops;
    long sea_money;
    long air_money;
    long spy_money;
    long army_money;
    float levels[4];        /* tech/res/edu/hap levels */
};
