/*
 * treaty.h
 *
 * things having to do with treaties
 *
 * from PSL Empire, 1985
 * $Revision: 1.1 $ $Date: 93/06/29 08:58:26 $
 */

struct	trtstr {
	natid	trt_cna;	/* proposer */
	natid	trt_cnb;	/* acceptor */
	char	trt_status;	/* treaty status */
	char	trt_fill;
	short	trt_acond;	/* conditions for proposer */
	short	trt_bcond;	/* conditions for accepter */
	float	trt_bond;	/* amount of bond involved */
	time_t	trt_exp;	/* expiration date */
};

struct	tchrstr {
	int	t_cond;		/* bit to indicate this clause */
	char	*t_name;	/* description of clause */
};

#define TS_FREE		0
#define TS_PROPOSED	1
#define TS_SIGNED	2

	/* treaty clauses */
#define	SEAATT	bit(0)		/* no attacks on ships */
#define	SEAFIR	bit(1)		/* no shelling ships */
#define	LANATT	bit(2)		/* no attacks on sectors */
#define	LANFIR	bit(3)		/* no shelling sectors */
#define	NEWSHP	bit(4)		/* no new ships */
#define	NEWNUK	bit(5)		/* no new nuclear weapons */
#define	NEWPLN	bit(6)		/* no new planes */
#define	TRTENL	bit(7)		/* no enlistment */
#define NEWTNK  bit(8)          /* no new tanks */
#define BUYPLN  bit(9)          /* no aircraft purchases */
#define BUYSHP  bit(10)         /* no ship purchases */
#define BUYTNK  bit(11)         /* no tank purchases */
#define SURREN  bit(12)         /* complete surrender */

/* global treaty variables */

#define gettre(n, p) \
	ef_nbread(EF_TREATY, n, (caddr_t)p)
#define puttre(n, p) \
	ef_nbwrite(EF_TREATY, n, (caddr_t)p)
#define gettrep(n) \
	(struct trtstr *) ef_ptr(EF_TREATY, n)

extern  struct tchrstr tchr[];
