/*
**  shop.h - Trade Center stuff
**
**  11/21/90 - Bill Frolik
*/

#define UC        unsigned char
#define SUC	  8

typedef struct {		  /* Each item has:			*/
    float buyprice;		  /*   what seller will pay to buy more */
    float sellprice;		  /*   base price to the buyer          */
    short hiwater;		  /*   don't buy if now have this much  */
    short lowater;                /*   don't sell if only have this much*/
} stockitem;

typedef struct {		  /* Each tradecenter has:		*/
    coord x,y;			  /*   x,y coordinates			*/
    UC openflags[(MAXNOC+1)/SUC]; /*   with whom we'll do business      */
    float pricemult[MAXNOC];	  /*   per-country price multipliers    */
    stockitem item[I_MAX+1];	  /*   prices on all the commodities    */
} tradecenter;

#define SOT	sizeof(tradecenter)
