/*
**  class.h
**
**  Vehicle class definitions
**
**  8/20/91 Bill Frolik
**
**  $Revision: 1.1 $ $Date: 93/06/29 08:58:12 $
*/

#ifndef HAVE_CLASS
#define HAVE_CLASS

struct classstr {
    char *name;		/* name of a particular vehicle class */
    char *birthplace;	/* list of sectors in which it can be built */
    char *loadplace;    /* list of sectors in which it can load/unload */
    char *stopplace;    /* list of sectors in which it can stop */
};

#ifdef MODIFYMOBILITY
#define shipterrain     "x.= "  	/* note: 'h' omitted on purpose! */
#define tankterrain     "~.,/"
#define balloonterrain  "~^"
#define spaceterrain	"~" 	 	/* permitted everywhere */
#define trainterrain    "~.,/"
#define atvterrain      "~.,"
#else
#define shipterrain     "x.= "  	/* note: 'h' omitted on purpose! */
#define tankterrain     "~.,^/#"
#define balloonterrain  "~^"
#define spaceterrain	"~" 	 	/* permitted everywhere */
#define trainterrain    "~.,^/#"
#define atvterrain      "~.,"
#endif

#define CLASS_SHIP	0	/* ships, witches, things that float */
#define CLASS_TANK	1	/* tanks, armored vehicles */
#define CLASS_BALLOON	2	/* balloons, airships, things that fly */
#define CLASS_TRAIN	3	/* trains */
#define CLASS_SPACE	4	/* spacecraft */
#define NUM_CLASSES     5	/* total number of classifications */

#define vcmask(a,b,c,d) \
    (((a)>=0) ? (1<<(a)) : 0) | \
    (((b)>=0) ? (1<<(b)) : 0) | \
    (((c)>=0) ? (1<<(c)) : 0) | \
    (((d)>=0) ? (1<<(d)) : 0)
    
extern  struct classstr class[];

#endif
