#ifndef lint
static char *RCSid = "$Header: tele.c,v 1.4 90/03/19 10:59:26 mr-frog Exp $";
#endif

/*
 * tele.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "news.h"
#include "deity.h"
#include "file.h"

tele()
{
	extern	s_char *argp[];
	extern	double dolcost;
	extern	int btused;
	natid	to;
	struct	natstr *natp;
	struct	natstr *np;
	int	teltype;
	s_char    buf[MAXTELSIZE+1];
	int	n;
	int	nsent;

	natp = getnatp(cnum);
	if (*argp[0] == 'a') {
		if (getele("everybody", buf) <= 0) {
			pr("Telegram aborted\n");
			return RET_SYN;
		}
		pr("\n");
		nsent = 0;
		for (to=0; np = getnatp(to); to++) {

/* Commented out to allow announcements to bounce back to sender..-=Evil 			if (to == cnum)
				continue;
*/
			if (((np->nat_stat & STAT_NORM) == 0) &&
				((np->nat_stat & STAT_SANCT) == 0))
				continue;
#ifdef	REJECTS
			if (!god && (getrejects(cnum,np) & REJ_ANNO)) {
#ifndef MERC
				pr(fmt("%s is rejecting your announcements.\n",
					cname(to)));
#endif
				continue;
			}
#endif	REJECTS
#ifdef WIRE
                        if (typed_wire(cnum, to, buf, TEL_ANNOUNCE))
                                logerror("tele: typed_wire failed to #%d", to);
#else
			if (typed_wu(cnum, to, buf, TEL_ANNOUNCE))
				logerror("tele: typed_wu failed to #%d", to);
#endif
			nsent++;
		}
#ifdef MERC
		dolcost += 0 * nsent;
		btused += 0;
#else
		dolcost += 3 * nsent;
		btused += nsent/2;
#endif
	} else {
		int	kk;

		kk = 1;
		while (argp[kk] != (s_char *)0){
			if ((n = natarg(argp[kk], "for which country? ")) < 0)
				return RET_SYN;

			to = n;

			if (kk == 1){
				if (argp[2]){
					if(getele("multiple recipients",buf)<0){
						pr("Telegram aborted\n");
						return RET_SYN;
					}
				}else{
					if (getele(cname(to), buf) < 0) {
						pr("Telegram aborted\n");
						return RET_SYN;
					}
				}
				pr("\n");
			}

			natp = getnatp(to);
			if (((natp->nat_stat & STAT_NORM) == 0) &&
				((natp->nat_stat & STAT_SANCT) == 0)){
				pr(fmt("%s has no \"telegram priveleges\".\n",
					cname(to)));
				kk++;
				continue;
			}
#ifdef	REJECTS
			if (!god && (getrejects(cnum,natp) & REJ_TELE)) {
				pr(fmt("%s is rejecting your telegrams.\n",
					cname(to)));
				return RET_SYN;
			}
#endif	REJECTS
			teltype = god ? TEL_BULLETIN : TEL_NORM;
			if (typed_wu(cnum, to, buf, teltype) < 0) {
				logerror("tele: typed_wu failed to #%d", n);
				return RET_FAIL;
			}

#ifndef NO_TELE_IN_NEWS
			if (!god && (natp->nat_stat & GOD) != GOD)
				nreport(cnum, N_SENT_TEL, to, 1);
#endif
#ifdef MERC
			dolcost += 0;
#else
			dolcost += 5;
#endif
			kk++;
		}
	}
	return RET_OK;
}
