#ifndef lint
static char *RCSid = "$Header: /sequent2/empire/EMP/player/commands/RCS/rela.c,v 1.6 89/09/10 19:07:49 mr-frog Exp $";
#endif /* not lint */

/*
 * rela.c
 *
 * hacked from nati.c
 *
 */

#include "misc.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

/*
 * report relations with other countries.
 * Optional argument reports relations from the
 * viewpoint of another country
 */
int
rela()
{
	extern	s_char *argp[];
	struct	natstr *natp;
	struct	natstr *np;
	natid	cn;
	natid	as;
	int	n;

#ifdef SILENT
	int     silent =0;
	        /* Michael Feuell (elf@twain.ucs.umass.edu) Jun 1991 */

	if (argp[2] && argp[2][0]=='s') silent =1;
#endif
	if (argp[1] == 0)
		as = cnum;
	else {
		if ((n = natarg(argp[1], "Which country? ")) <= 0) {
			pr("Bad country number\n");
			return RET_SYN;
		}
		as = (natid) n;
	}
	if ((natp = getnatp(as)) == 0) {
		pr(fmt("Bad country number %d\n", cnum));
		return RET_SYN;
	}
	pr(fmt("\t%s Diplomatic Relations Report\t", cname(as)));
	prdate();
#ifdef SLOW_WAR
	pr(fmt("\n  Formal Relations         %5s      theirs\n",
			cnum == as ? "yours" : "his"));
#else
	pr(fmt("\n  Formal Relations         %5s     theirs\n",
			cnum == as ? "yours" : "his"));
#endif /* SLOW_WAR */
	for (cn=1; cn < MAXNOC; cn++) {
		if ((np = getnatp(cn)) == 0)
			break;
		if (cn == as)
			continue;
		if ((np->nat_stat & STAT_NORM) == 0 &&
		    (np->nat_stat & STAT_SANCT) == 0)
			continue;
#ifdef SILENT
		if (silent && (getrel(natp,cn)==NEUTRAL) &&
		    (getrel(np,as)==NEUTRAL)) continue;
#endif
		pr(fmt("%3d) %-20.20s  ", cn, cname(cn)));
#ifdef SLOW_WAR
		pr(fmt("%-10s %s\n", relatename(natp, cn), relatename(np, as)));
#else
		pr(fmt("%-9s %s\n", relatename(natp, cn), relatename(np, as)));
#endif /* SLOW_WAR */
	}
	return RET_OK;
}
