#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/wu.c,v 1.1 89/05/10 02:54:15 muir Exp $";
#endif

/*
 * wu.c
 *
 * server in-memory version of wu.
 * has one long "production" telegram
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "news.h"
#include "tel.h"
#include "nat.h"
#include "file.h"

#include <stdio.h>
#include <sys/file.h>

struct msg {
	struct msg *m_next;
	int m_len;
	char *m_text;
};

struct	msg *msgs[MAXNOC];

/*
 * ignore "from" field
 * it is there for historical reasons
 */
/*ARGSUSED*/
wu(from, to, text)
	int	from;
	int	to;
	char	*text;
{
	struct	msg *mp;

	mp = (struct msg *) malloc(sizeof(struct msg));
	mp->m_next = msgs[to];
	mp->m_len = strlen(text);
	mp->m_text = strcpy(malloc((unsigned)mp->m_len+1), text);
	msgs[to] = mp;
}

flushwu()
{
	register struct msg *mp;
	register int len;
	struct	natstr *np;
	struct	telstr t;
	int	i;
	FILE	*fp;
	long	now;

	(void) time(&now);
	for (i=0; np = getnatp(i); i++) {
		if (msgs[i] == 0)
			continue;
		t.tel_from = 0;
		t.tel_date = now;
		t.tel_type = TEL_UPDATE;
		t.tel_length = 0;
		if ((fp = fopen(mailbox(i), "a+")) == 0) {
			logerror("cannot open mailbox %s", mailbox(i));
			continue;
		}
		len = 0;
		for (mp = msgs[i]; mp != 0; mp = mp->m_next)
			len += mp->m_len;
		t.tel_length = len;
		if (len <= 0)
			continue;
		(void) fwrite((char *)&t, sizeof(t), 1, fp);
		wwu(fp, msgs[i]);
		(void) fflush(fp);
		(void) fclose(fp);
		msgs[i] = 0;
		np->nat_tgms++;
	}
}

wwu(fp, mp)
	FILE	*fp;
	struct	msg *mp;
{
	if (mp->m_next)
		wwu(fp, mp->m_next);
	fputs(mp->m_text, fp);
	free((char *)mp->m_text);
	free((char *)mp);
}
