#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/sect.c,v 1.6 89/05/10 02:54:07 muir Exp $";
#endif

/*
 * sect.c
 *
 * perform production updates of the sect and
 * ship files.
 * 
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"

extern	float levels[MAXNOC][4];

prod_sect(etu)
	int	etu;
{
	extern	int pops[];
	register struct sctstr *sp;
	struct	natstr *np;
	int	n;
	int	vec[I_MAX+1];
	int	changed;

	bzero((char *)levels, sizeof(levels));
	/*
	 * first produce everything, then do deliveries
	 * and distributes
	 */
	for (n=0; sp = getsectid(n); n++) {
		if (sp->sct_type == SCT_WATER)
			continue;
		np = getnatp(sp->sct_own);
		guerrilla(sp);
		update(sp, etu, np, &pops[sp->sct_own]);
	}
	for (n=0; sp = getsectid(n); n++) {
		if (sp->sct_type == SCT_WATER)
			continue;
		np = getnatp(sp->sct_own);
		if (np->nat_money < 0)
			continue;
		changed = 0;
		if (getvec(VT_ITEM, sp, EF_SECTOR, vec) > 0)
			changed += dodeliver(sp, vec);
		changed += dodistribute(sp, vec);
		if (changed)
			putvec(VT_ITEM, sp, EF_SECTOR, vec);
	}
}

/*
 * update the individual sector
 *
 */
update(sp, etus, np, pop)
	register struct sctstr *sp;
	register int etus;
	register struct natstr *np;
	long	*pop;
{
	extern	double populace();
	extern	double bankint;
	int	vec[I_MAX+1];
	int	cvec[I_MAX+1];
	int	people;
	int	work;
	int	n;

	if (getvec(VT_ITEM, sp, EF_SECTOR, vec) <= 0)
		return;
	if (vec[I_CIVIL] == 0 && vec[I_MILIT] == 0)
		return;
	/* calculate the workforce */
	work = roundavg((etus * populace(np, sp, vec, etus)) / 100.0);
	if ((sp->sct_effic < 100 || sp->sct_type != sp->sct_newtype) &&
	    np->nat_money > 0) {
		n = buildeff(sp, work/2);
		np->nat_money -= n;
		work -= n;
	}
	getvec(VT_COND, sp, EF_SECTOR, cvec);
	/*
	 * if everyone is about to starve, or we're an agro,
	 * grow emergency rations.
	 */
	people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
	if (sp->sct_type == SCT_AGRI || vec[I_FOOD] < people/10)
		work -= growfood(sp, vec);
	if (sp->sct_type != SCT_SANCT && (n = feed_people(vec, etus)) > 0) {
		wu(0, sp->sct_own, fmt("%d starved in %s.\n", n, ownxy(sp)));
		if (n > 25)
			nreport((int) sp->sct_own, N_DIE_FAMINE, 0, 1);
		starvation(sp);
	} else {
		if (sp->sct_work < 100)
			sp->sct_work += 8 + (random() % 15);
		if (sp->sct_work > 100)
			sp->sct_work = 100;
		grow_people(vec, etus);
	}
	if (cvec[C_PSTAGE] == 0) {
		infect_people(np, vec, sp->sct_effic, sp->sct_mobil);
	} else {
		n = plague_people(np, vec, cvec, etus);
		switch (n) {
		case PLG_DYING:
			wu(0, sp->sct_own,
				fmt("PLAGUE deaths reported in %s.\n",
				ownxy(sp)));
			nreport((int)sp->sct_own, N_DIE_PLAGUE, 0, 1);
			break;
		case PLG_INFECT:
			wu(0, sp->sct_own, fmt("%s battling PLAGUE\n",
				 ownxy(sp)));
			break;
		case PLG_INCUBATE:
			/* plage has moved into "infectious" stage */
			if (n != cvec[C_PSTAGE]) {
				wu(0, sp->sct_own,
					fmt("Outbreak of PLAGUE in %s!\n",
					ownxy(sp)));
				nreport((int)sp->sct_own, N_OUT_PLAGUE, 0, 1);
			}
			break;
		case PLG_EXPOSED:
		default:
			break;
		}
	}
	if (sp->sct_type == SCT_ENLIST && sp->sct_effic >= 60 &&
	    sp->sct_own == sp->sct_oldown)
		np->nat_money -= enlist(vec, etus) * 3;
	/*
	 * now do the production (if sector effic > 60%)
	 */
	if (sp->sct_effic > 60) {
		if (sp->sct_type == SCT_BANK) {
			np->nat_money = vec[I_BAR] * etus * bankint;
		} else if (sp->sct_type == SCT_CAPIT) {
			/* 
			 * XXX produce btu's here?
			 */
			np->nat_money -= etus;
		}
		if (np->nat_money > 0 && dchr[sp->sct_type].d_prd)
			work -= produce(np, sp, vec, work);
	}
	/*
	 * only non-captured civs add to census for nation
	 */
	if (sp->sct_oldown == sp->sct_own)
		*pop += vec[I_CIVIL];
	putvec(VT_ITEM, sp, EF_SECTOR, vec);
	putvec(VT_COND, sp, EF_SECTOR, cvec);
	sp->sct_avail = work;
}

int
dodeliver(sp, vec)
	struct	sctstr *sp;
	int	*vec;
{
	register int i;
	int	del[I_MAX+1];
	int	thresh;
	int	dir;
	int	plague;
	int	n;
	int	changed;

	if (sp->sct_mobil <= 0)
		return 0;
	if (getvec(VT_DEL, sp, EF_SECTOR, del) <= 0)
		return 0;
	changed = 0;
	plague = getvar(V_PTIME, sp, EF_SECTOR);
	for (i=1; i<=I_MAX; i++) {
		if (del[i] == 0)
			continue;
		thresh = del[i] & ~0x7;
		dir = del[i] & 0x7;
		n = deliver(sp, &ichr[i], dir, thresh, vec[i], plague);
		if (n > 0)  {
			vec[i] -= n;
			changed++;
			if (sp->sct_mobil <= 0)
				break;
		}
	}
	return changed;
}

/*
 * Increase sector efficiency if old type == new type.
 * decrease sector efficiency if old type != new type.
 * Return amount of work used.
 */
int
buildeff(sp, work)
	register struct sctstr *sp;
	int	work;
{
	register int work_cost;
	int	total_cost;

	work_cost = 0;
	total_cost = 0;
	if (sp->sct_type != sp->sct_newtype) {
		/*
		 * Tear down existing sector.
		 * Easier to destroy than to build.
		 */
		work_cost = (sp->sct_effic + 3) / 4;
		if (work_cost > work)
			work_cost = work;
		sp->sct_effic -= work_cost * 4;
		if (sp->sct_effic == 0)
			sp->sct_type = sp->sct_newtype;
		work -= work_cost;
		total_cost += work_cost;
	}
	if (sp->sct_type == sp->sct_newtype) {
		work_cost = 100 - sp->sct_effic;
		if (work_cost > work)
			work_cost = work;
		sp->sct_effic += work_cost;
		total_cost += work_cost;
	}
	return total_cost;
}

int
growfood(sp, vec, work, etus)
	struct	sctstr *sp;
	register int *vec;
	int	work;
	int	etus;
{
	extern	double fgrate;
	extern	double fcrate;
	double	food_fertil;
	double	food_workers;
	double	food;
	int	work_used;

	food_workers = work * fcrate;
	food_fertil = sp->sct_fertil * fgrate;
	food = food_fertil;
	if (food > food_workers)
		food = food_workers;
	vec[I_FOOD] = roundavg(food * etus);
	work_used = food / fcrate;
	return work_used;
}

/*
 * enlistment sectors are special; they require military
 * to convert civ into mil in large numbers.
 * Conversion will happen much more slowly without
 * some mil initially.
 */
int
enlist(vec, etus)
	register int *vec;
	int	etus;
{
	int	maxmil;
	int	enlisted;

	enlisted = 0;
	maxmil = (vec[I_CIVIL] / 2) - vec[I_MILIT];
	if (maxmil > 0) {
		enlisted = (etus * (10 + vec[I_MILIT]) * 0.05);
		if (enlisted > maxmil)
			enlisted = maxmil;
		vec[I_CIVIL] -= enlisted;
		vec[I_MILIT] += enlisted;
	}
	return enlisted;
}
