#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/nat.c,v 1.1 89/05/10 02:53:51 muir Exp $";
#endif

/*
 * nat.c
 *
 * Accumulate tech, edu, research, and happiness.
 * Share them among allies.
 * 
 * and Dave Pare, 1989
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"

float	levels[MAXNOC][4];

/*
 * hap and edu avg mean that the weight on current happiness is
 *  (cur_hap * hap_avg + hap_prod * etu) / (hap_avg + etu);
 * same for education.
 * right now, happiness has 1 day (48 etu) average, prod of 10 from
 * initial level of 0 yields (1) 1.42, (6) 6.03, (12) 8.42, (18) 9.37
 *
 * education has 4 day (192 etu) average, prod of 10 from initial
 * level of 0 yields (1) 0.4, (6) 2.2, (12) 3.9, (18) 5.2.
 */

extern float	hap_avg;
extern float	edu_avg;
extern float	ally_factor;
extern float	hard_tech;
extern float	easy_tech;
extern float	tech_log_base;

/*
 * technique to limit the sharpers who turn entire countries
 * into tech plants overnight...
 */

double
limit_tech(tlev) 
	double	tlev;
{
	if (tlev > easy_tech) {
		tlev -= easy_tech;
		if (tech_log_base > 1.0)  {
			if (tlev > tech_log_base) {
				tlev = tech_log_base - 1 + log10(tlev) /
					log10(tech_log_base);
			}
		} else {
			if (hard_tech > 0.0) {
				tlev = hard_tech * (tlev / (tlev +hard_tech));
			}
		}
		tlev += easy_tech;
	}
	return tlev;
}

prod_nat(etu)
	int	etu;
{
	extern	long money[MAXNOC];
	extern	double money_res;
	extern	long pops[MAXNOC];
	extern	double hap_cons, edu_cons;
	struct	natstr *np;
	float	hap;
	float	edu;
	float	hap_edu;
	long	pop;
	double	rlev;
	double	tlev;
	double	tech[MAXNOC];
	double	res[MAXNOC];
	int	n;

	for (n=0; np = getnatp(n); n++) {
		if ((np->nat_stat & STAT_NORM) == 0)
			continue;
		/*
		 * hap_edu: the more education people have, the
		 * more happiness they want.
		 */
		hap_edu = np->nat_level[NAT_ELEV];
		hap_edu = 1.5 - ((hap_edu + 10.0) / (hap_edu + 20.0));
		pop = pops[n] + 1;
		/*
		 * get per-population happiness and education
		 * see what the total per-civilian production is
		 * for this time period.
		 */
		np->nat_money += (np->nat_reserve * money_res);
		hap = (levels[n][NAT_HLEV] * hap_edu) / ((float)pop / hap_cons);
		edu = levels[n][NAT_ELEV] / ((float)pop / edu_cons);
		wu(0, n, fmt("%3.0f happiness, %3.0f education produced\n",
			levels[n][NAT_HLEV], levels[n][NAT_ELEV]));
		/*
		 * change the "moving average"...old happiness and
		 * education levels are weighted heavier than current
		 * production.
		 */
		np->nat_level[NAT_HLEV] =
			(np->nat_level[NAT_HLEV] * hap_avg + hap * etu) / 
			(hap_avg + etu);
		np->nat_level[NAT_ELEV] =
			(np->nat_level[NAT_ELEV] * edu_avg + edu * etu) / 
			(edu_avg + etu);
		/*
		 * limit tech/research production
		 */
		levels[n][NAT_TLEV] = limit_tech((double)levels[n][NAT_TLEV]);
		levels[n][NAT_RLEV] = limit_tech((double)levels[n][NAT_RLEV]);
		wu(0, n, fmt("total pop is %d, yielding %4.2f hap, %4.2f edu\n",
			pop - 1, hap, edu));
	}
	if (ally_factor > 0.0)
		share_incr(res, tech);
	else {
		bzero(res, sizeof(res));
		bzero(tech, sizeof(tech));
	}
	for (n=0; np = getnatp(n); n++) {
		if ((np->nat_stat & STAT_NORM) == 0)
			continue;
		tlev = levels[n][NAT_TLEV];
		rlev = levels[n][NAT_RLEV];
		np->nat_level[NAT_TLEV] += tlev + tech[n];
		np->nat_level[NAT_RLEV] += rlev + res[n];
		if (tech[n] != 0.0 || res[n] != 0.0) {
			wu(0, n, fmt("%5.4f technology (%5.4f + %5.4f), ",
				tlev + tech[n], tlev, tech[n]));
			wu(0,n, fmt("%5.4f research (%5.4f + %5.4f) produced\n",
				rlev + res[n], rlev, res[n]));
		} else
			wu(0, n, fmt("%5.4f tech, %5.4f research produced\n",
				     tlev, rlev));
		wu(0, n, fmt("money delta was $%d for this update\n",
			np->nat_money - money[n]));
	}
}

/*
 * find out everyones increment
 */
share_incr(res, tech)
	register double *res;
	register double *tech;
{
	register struct natstr *np;
	register struct natstr *other;
	register int i;
	register int j;
	register int nc;

	for (i=0; np = getnatp(i); i++) {
		if ((np->nat_stat & STAT_INUSE) == 0)
			continue;
		nc = 0;
		res[i] = tech[i] = 0.0;
		for (j=0; other = getnatp(j); j++) {
			if (j == i)
				continue;
			if (getrel(np, j) != ALLIED)
				continue;
			if (getrel(other, i) != ALLIED)
				continue;
			res[i] += levels[j][NAT_RLEV];
			tech[i] += levels[j][NAT_TLEV];
			nc++;
		}
		if (nc == 0)
			continue;
		nc++;
		res[i] /= nc * ally_factor;
		tech[i] /= nc * ally_factor;
		logerror("Country #%d gets %g res and %g tec from %d allies",
			i, res[i], tech[i], nc - 1);
	}
}
