#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/mobility.c,v 1.7 89/05/10 02:53:49 muir Exp $";
#endif

/*
 * mobility.c
 *
 * Add mobility to each of the items which accumlate mobility.
 * 
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nat.h"
#include "file.h"
#include "tm.h"
#include "update.h"

mob_sect(etus)
	register int etus;
{
	register struct sctstr *sp;
	register int value;
	register int n;

	for (n=0; sp = getsectid(n); n++) {
		if (sp->sct_own == 0)
			continue;
		value = sp->sct_mobil + etus;
		if (value > 127)
			value = 127;
		sp->sct_mobil = value;
	}
}

mob_ship(etus)
	register int etus;
{
	register struct shpstr *sp;
	register int value;
	register int n;

	for (n=0; sp = getshipp(n); n++) {
		if (sp->shp_own == 0)
			continue;
		value = sp->shp_mobil + etus * MOBSHIPSCALE;
		if (value > MAXSHIPMOB)
			value = MAXSHIPMOB;
		sp->shp_mobil = value;
	}
}

mob_plane(etus)
	register int etus;
{
	register struct plnstr *pp;
	register int value;
	register int n;

	for (n=0; pp = getplanep(n); n++) {
		if (pp->pln_own == 0)
			continue;
		value = pp->pln_mobil + etus;
		if (value > 127)
			value = 127;
		pp->pln_mobil = value;
	}
}
