#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/update/RCS/age.c,v 1.9 89/05/10 02:52:49 muir Exp $";
#endif

/*
 * age.c
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

age_levels(etu)
	int	etu;
{
	extern	float	level_age_rate;
	register float best_tech;
	register float best_res;
	register struct natstr *np;
	register int j;
	float	*ptr;
	int	i;

	best_tech = 0.0;
	best_res = 0.0;
	for (i=0; np = getnatp(i); i++) {
		if ((np->nat_stat & STAT_NORM) == 0)
			continue;
		/*
		 * age levels by 1% per every 48 etus
		 */
		if (best_tech < np->nat_level[NAT_TLEV])
			best_tech = np->nat_level[NAT_TLEV];
		if (best_res < np->nat_level[NAT_RLEV])
			best_res = np->nat_level[NAT_RLEV];
		if (level_age_rate != 0.0) {
			for (j=0; j<4; j++) {
				np->nat_level[j] *= (1.0 - 
					(double)etu/(100*level_age_rate));
			}
		}
		/*
		 * age reserves by 1% per every 24 etus
		 */
		np->nat_reserve =
			(np->nat_reserve * (1.0 - (double)etu/2400.0)) + 0.5;
	}
	best_tech /= 5;
	best_res /= 5;
	for (i=0; np = getnatp(i); i++) {
		if ((np->nat_stat & STAT_INUSE) == 0)
			continue;
		ptr = &np->nat_level[NAT_TLEV];
		if (*ptr < best_tech && chance(0.2))
			*ptr += (best_tech - *ptr) / 3;
		ptr = &np->nat_level[NAT_RLEV];
		if (*ptr < best_res && chance(0.2))
			*ptr += (best_res - *ptr) / 3;
	}
}
