#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/service.c,v 1.5 89/05/10 02:51:48 muir Exp $";
#endif

/*
 * service.c
 *
 * service a user socket by reading all the
 * commands and executing the right routines.
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <errno.h>
#include "sailio.h"
#include "user.h"
#include "tm.h"

int	tm_answer[10];
int	seq;

/*
 * return 1 means the socket is closed
 * return 0 everything ok
 */
int
service(up)
	struct	user *up;
{
	extern	int tm_flags;
	extern	int errno;
	char	*argp[25];
	char	buf[80];
	int	detail;
	int	which;
	SAIL	*iop;

	iop = up->u_iop;
	while (sgets(buf, sizeof(buf), iop, 0) != 0 && sio_flags(iop) == 0) {
		if (tm_parse(buf, argp) <= 0) {
			/* error */
			continue;
		}
		seq = tm_answer[1];
		which = tm_answer[2];
		detail = tm_answer[3];
		switch (tm_answer[0]) {
		case C_IDENT:
			up->u_pid = which;
			up->u_cnum = detail;
			sendnum(iop, seq, TM_OK);
			/*logerror("user sends ident");*/
			break;
		case C_LOCK:
			if (tm_flags) {
				/* update is waiting to occur */
				sendnum(iop, seq, TM_ERROR);
				logerror("tm file locked");
				return 0;
			}
			/* lock will complain if it needs to */
			if (lock(up, detail))
				sendnum(iop, seq, TM_OK);
			break;
		case C_UNLOCK:
			unlock(up, detail);
			sendnum(iop, seq, TM_OK);
			/*logerror("unlock file");*/
			break;
		case C_NATMOD:
			/* natmod verifies stuff, bcasts if ok */
			if (natmod(argp, tm_answer) == 0) {
				logerror("bad natmod string: %s", buf);
				sendnum(iop, seq, TM_ERROR);
			}
			break;
		case C_NEWS:
			nreport(tm_answer[2], tm_answer[3], tm_answer[4],
				tm_answer[5]);
			break;
		case C_SYNC:
			sendnum(iop, seq, TM_OK);
			break;
		default:
			sendnum(iop, seq, TM_PANIC);
			logerror("bad tm request type: %s", buf);
			break;
		}
		*buf = 0;
	}
	if (sio_err(iop) || sio_conn(iop)) {
		if (sio_err(iop)) {
			errno = sio_errno(iop);
			logerror("iop error");
		}
		/*logerror("connection closed");*/
		unlock_clean(up);
		sclose(iop);
		up->u_iop = 0;
		return 1;
	} else if (sio_eof(iop))
		sio_clr(iop);
	return 0;
}

static
int
tm_parse(buf, argp)
	char	*buf;
	char	**argp;
{
	static	char space[255];
	int	i;
	int	n;

	n = parse(buf, argp, (char **)0, space);
	if (n <= 0 || n > 10)
		return 0;
	for (i=0; i<n; i++) {
		tm_answer[i] = atoi(argp[i]);
	}
	return n;
}
