static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/news.c,v 1.4 89/05/10 02:51:40 muir Exp $";

/*
 * news.c
 *
 * server in-memory version of news stuff.
 * We keep track of a list of free news articles,
 * and use them when a news request arrives.
 *
 * from PSL Empire, 1985
 * Dave Pare, 1989
 */

#include "misc.h"
#include "news.h"
#include "file.h"
#include <sys/file.h>

struct free {
	struct free *next;
	int id;
};

struct	free *freelist;

/*
 * snoop through the news articles looking
 * for articles which have timed out.  Only
 * called when no free items left.
 */
int
findfree()
{
	register time_t oldnewstime;
	register int n;
	register struct free *fp;
	struct	nwsstr news;
	time_t	newstime;

	(void) time(&newstime);
	oldnewstime = newstime - NEWS_PERIOD;
	for (n=0; getnews(n, &news); n++) {
		if (news.nws_when < oldnewstime) {
			fp = (struct free *) malloc(sizeof(*fp));
			fp->next = freelist;
			fp->id = n;
			freelist = fp;
		}
	}
	if (freelist == 0) {
		makefree(250);
		findfree();
	}
}

/*
 * create some new (free) news articles.
 * articles with page = 0 are considered "free"
 */
makefree(n)
	int	n;
{
	int	start;
	struct	nwsstr news;

	start = ef_nelem(EF_NEWS);
	news.nws_ano = 0;
	news.nws_vrb = 0;
	news.nws_vno = 0;
	news.nws_ntm = 0;
	news.nws_when = 0;
	while (n > 0) {
		ef_nbwrite(EF_NEWS, start, (char *)&news);
		start++;
		n--;
	}
	/* reopen the file */
	ef_close(EF_NEWS);
	ef_open(EF_NEWS, O_RDWR, 0);
}

nreport(actor, event, victim, times)
	int	actor;
	int	event;
	int	victim;
	int	times;
{
	struct	free *fp;
	int	id;
	struct	nwsstr news;

	if (freelist == 0)
		findfree();
	fp = freelist;
	freelist = fp->next;
	id = fp->id;
	free(fp);
	if (event == N_WON_SECT && victim == 0)
		event = N_TOOK_UNOCC;
	news.nws_ano = actor;
	news.nws_vrb = event;
	news.nws_vno = victim;
	news.nws_ntm = times;
	time(&news.nws_when);
	ef_nbwrite(EF_NEWS, id, (char *)&news);
}
