#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/main.c,v 1.12 89/05/10 02:51:32 muir Exp $";
#endif

/*
 * main.c
 *
 * main command loop and initialization
 * for empire tm server
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/un.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include "tm.h"
#include "misc.h"
#include "sailio.h"
#include "user.h"
#include "update.h"
#include "bit.h"
#include "file.h"

static	int max_fd;
static	int expire;

char	*program = "tm_server";

alarmhandler()
{
	expire++;
}

main()
{
	int	catch();
	extern	int exit();
	extern	long s_p_etu;
	extern	long upd_adj;
	extern	char gamedir[];
	extern	int errno;
	register int n;
	struct	sockaddr_un un;
	struct	user *up;
	bit_fdmask savemask;
	bit_fdmask mask;
	long	now;
	long	delta;
	int	s;
	int	reserve;
	int	fd;

#ifndef DEBUG
	/*disassoc();*/
#else
	close(0);
	close(1);
	close(2);
#endif
	time(&now);
	srandom(now);
	initfiles();
	(void) signal(SIGALRM, alarmhandler);
	(void) signal(SIGTERM, exit);
#ifndef DEBUG
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGBUS, catch);
	(void) signal(SIGILL, catch);
	(void) signal(SIGFPE, catch);
	(void) signal(SIGSEGV, catch);
#endif
	delta = update_delta();
#ifdef notdef
	(void) alarm(delta);
#endif
	now += delta;
	errno = 0;
	logerror("Next update at %20.20s (%d seconds)", ctime(&now), delta);
	(void) sprintf(un.sun_path, "%s/tm_socket", gamedir);
	un.sun_family = AF_UNIX;
	if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
		logerror("unix socket create");
		exit(1);
	}
	unlink(un.sun_path);
	if (bind(s, (struct sockaddr *) &un, strlen(un.sun_path)+2) < 0) {
		logerror("unix socket bind");
		exit(1);
	}
	if (listen(s, 5) < 0) {
		logerror("unix socket listen");
		exit(1);
	}
	logerror("listen");
	savemask = bit_newfdmask();
	mask = bit_newfdmask();
	BIT_SETB(s, savemask);
	max_fd = s;
	logerror("tm server started, pid %d", getpid());
	/* squirrel away file descriptors "for later" */
	reserve = getdtablesize() - 5;
	for (;;) {
		if (expire) {
			schedule();
			expire = 0;
		}
		bit_copy(savemask, mask);
		if (select(max_fd+1, mask, 0, 0, 0) < 0) {
			if (errno == EINTR) {
				/* a signal! */
				errno = 0;
				continue;
			}
			logerror("main loop select");
			exit(1);
		}
		if (BIT_ISSETB(s, mask)) {
			if ((up = newuser(s, reserve)) == 0) {
				logerror("newuser failed");
				continue;
			}
			/*logerror("new user");*/
			BIT_SETB(up->u_iop->fd, savemask);
			BIT_CLRB(s, mask);
			if (max_fd < up->u_iop->fd)
				max_fd = up->u_iop->fd;
		}
		while ((fd = bit_fd(mask)) >= 0) {
			if ((up = userbyfd(fd)) == 0) {
				logerror("cannot find user to match fd %d", fd);
				(void) close(fd);
				BIT_CLRB(fd, savemask);
			} else if (service(up)) {
				/*logerror("user leaving");*/
				if (fd == max_fd)
					max_fd--;
				BIT_CLRB(fd, savemask);
			}
			BIT_CLRB(fd, mask);
		}
		for (n=0,up=users; n < maxusers; n++,up++) {
			if (up->u_iop == 0)
				continue;
			if (sio_output(up->u_iop)) {
				sflush(up->u_iop);
			}
		}
		/*
		 * flush delayed writes
		 */
		dw_flush();
	}
}

catch(sig)
	int	sig;
{
	logerror("trapped signal %d", sig);
	(void)signal(SIGIOT, SIG_DFL);		/* For Sun */
	(void)signal(SIGILL, SIG_DFL);		/* For VAX */
	(void)abort();
}
