#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/lock.c,v 1.5 89/05/10 02:51:30 muir Exp $";
#endif

/*
 * lock.c
 *
 * set and unset locks on given files by-user.
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include "misc.h"
#include <netinet/in.h>
#include <errno.h>
#include <signal.h>
#include "sailio.h"
#include "user.h"
#include "tm.h"
#include "file.h"

struct	shlock *locks[EF_MAX];

/*
 * user places a particular kind
 * of lock on a batch of files
 */
int
lock(user, mask)
	struct	user *user;
	int	mask;
{
	extern	int seq;
	struct	shlock *lp;
	int	n;

	if (mask == 0) {
		logerror("lock: nothing to lock!");
		sendnum(user->u_iop, seq, TM_PANIC);
		return 0;
	}
	while ((n = ffs(mask)-1) >= 0) {
		if (n < 0 || n >= EF_MAX) {
			logerror("lock: request (%d) out of bounds", n);
			sendnum(user->u_iop, seq, TM_PANIC);
			return 0;
		}
		lp = (struct shlock *) malloc(sizeof(struct shlock));
		lp->next = locks[n];
		lp->who = user;
		locks[n] = lp;
		mask &= ~bit(n);
	}
	return 1;
}

/*
 * User removes a lock from a batch of files
 */
int
unlock(user, mask)
	struct	user *user;
	int	mask;
{
	register struct shlock **lp;
	struct	shlock *next;
	int	n;

	if (mask == 0)
		return 0;
	while ((n = ffs(mask)-1) >= 0) {
		if (n < 0 || n >= EF_MAX) {
			logerror("unlock file request (%d) out of bounds", n);
			sendnum(user->u_iop, seq, TM_PANIC);
			return 0;
		}
		for (lp = &locks[n]; *lp != 0; lp = &(*lp)->next) {
			if ((*lp)->who == user) {
				break;
			}
		}
		if (*lp != 0) {
			next = (*lp)->next;
			free((char *) *lp);
			*lp = next;
		}
		mask &= ~bit(n);
	}
	return 1;
}

/*
 * Sends HUP signal to all processes who have locks
 * on the specified file.
 * Returns true if all locks were broken.
 */
int
breaklock(type)
	int	type;
{
	register struct shlock *next;
	register struct shlock *lp;

	if (type < 0 || type >= EF_MAX)
		return 0;
	for (lp = locks[type]; lp != 0; lp = next) {
		next = lp->next;
		(void) kill(lp->who->u_pid, SIGHUP);
		logerror("forced lock on cnum %d, pid %d",
			lp->who->u_cnum, lp->who->u_pid);
		free((char *)lp);
	}
	return 1;
}

int
listlock(type)
	int	type;
{
	if (type < 0 || type >= EF_MAX)
		return 0;
	return locks[type] != 0;
}

int
unlock_clean(up)
	struct	user *up;
{
	int	i;

	for (i=0; i<EF_MAX; i++) {
		(void) unlock(up, bit(i));
	}
}
