static char *RCSid = "$Header: /usr6/postgres/muir/empire/tm/RCS/fileglb.c,v 1.1 89/05/10 02:51:26 muir Exp $";

/*
 * fileglb.c
 *
 * empire selection global structures.
 *
 */

#include <struct.h>
#include "misc.h"
#include "var.h"
#include "xy.h"
#include "loan.h"
#include "nsc.h"
#include "nuke.h"
#include "plane.h"
#include "ship.h"
#include "sect.h"
#include "trade.h"
#include "treaty.h"
#include "file.h"
#include "power.h"
#include "news.h"
#include "nat.h"

#include "gamesdef.h"

#define	EMPPATH(xxx)	GAMESPATH(xxx)

#ifdef EMPMAIN

extern	struct castr sect_ca[];
extern	struct castr news_ca[];
extern	struct castr loan_ca[];
extern	struct castr ship_ca[];
extern	struct castr plane_ca[];
extern	struct castr treaty_ca[];
extern	struct castr nuke_ca[];
extern	struct castr trade_ca[];

extern	int sct_postread(), sct_prewrite();
extern	int shp_postread(), shp_prewrite();
extern	int pln_postread(), pln_prewrite();

#else

#define	sect_ca		0
#define	news_ca		0
#define	loan_ca		0
#define	ship_ca		0
#define	plane_ca	0
#define	treaty_ca	0
#define	nuke_ca		0
#define	trade_ca	0

#define	sct_postread	0
#define	sct_prewrite	0
#define	shp_postread	0
#define	shp_prewrite	0
#define	pln_postread	0
#define	pln_prewrite	0

#endif

struct empfile empfile[] = {
	EMPPATH(DATA/empsect), EFF_COM|EFF_XY, 0, sizeof(struct sctstr),
	    sct_postread, sct_prewrite,
	    fldoff(sctstr, sct_nv), fldoff(sctstr, sct_vtype[0]),
	    fldoff(sctstr, sct_vamt[0]), MAXSCTV, 
	    -1, -1, 0, 0, 0, 0, sect_ca,
	EMPPATH(DATA/empnews),              0, 0, sizeof(struct nwsstr),
	     0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, news_ca,
	EMPPATH(DATA/emploan),              0, 0, sizeof(struct lonstr),
	     0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, loan_ca,
	EMPPATH(DATA/empship), EFF_COM|EFF_XY, 0, sizeof(struct shpstr),
	    shp_postread, shp_prewrite,
	    fldoff(shpstr, shp_nv), fldoff(shpstr, shp_vtype[0]),
	    fldoff(shpstr, shp_vamt[0]), MAXSHPV, 
	    -1, -1, 0, 0, 0, 0, ship_ca,
	EMPPATH(DATA/empplane), EFF_XY, 0, sizeof(struct plnstr),
	    pln_postread, pln_prewrite,
	    0, 0, 0, 0, -1, -1, 0, 0, 0, 0, plane_ca,
	EMPPATH(DATA/emptreaty), 0, 0, sizeof(struct trtstr),
	    0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, treaty_ca,
	EMPPATH(DATA/empnuke), EFF_XY, 0, sizeof(struct nukstr),
	    0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, nuke_ca,
	EMPPATH(DATA/emptrade),              0, 0, sizeof(struct trdstr),
	    0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, trade_ca,
	EMPPATH(DATA/emppow),     0, 0, sizeof(struct powstr),
	    0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0,
	EMPPATH(DATA/empnat),              0, 0, sizeof(struct natstr),
	    0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0,
};
