#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/RCS/minusm.c,v 1.6 89/05/09 23:20:57 muir Exp $";
#endif

/*
 * minusm.c
 *
 * find all the #include declarations in a list
 * of files (for those systems pre-bsd4.3
 *
 * Dave Pare, 1986
 */ 

#include <stdio.h>
#ifdef hpux
#include <sys/types.h>
#define rindex strrchr
#define index strchr
#endif
#include <sys/file.h>
#include <ctype.h>

char	*includes[20];
char	*defaults[] = { "/usr/include", };
char	name[1024];

#define	NDEFAULTS	1

main(argc, argv)
	int	argc;
	char	**argv;
{
	extern	char *strcpy();
	extern	char *index();
	extern	char *rindex();
	register char *p;
	char	buf[1024];
	char	fname[255];
	FILE	*fp;
	int	ni = 0;
	int	nd;
	int	i;
	int	len;
	char	*quote;
	char	*bracket;
	char	*end;
	char	curdir[255];
	int	n;

	len = strlen("include");
	nd = NDEFAULTS;
	for (i=1; i<argc; i++) {
		p = argv[i];
		if (*p != '-')
			continue;
		p++;
		if (*p != 'I')
			continue;
		p++;
		includes[ni++] = strcpy(malloc(strlen(p) + 1), p);
	}
	for (i=1; i<argc; i++) {
		if (argv[i][0] == '-')
			continue;
		if ((fp = fopen(argv[i], "r")) == 0) {
			perror(argv[i]);
			continue;
		}
		strcpy(name, argv[i]);
		if (strcmp (name + strlen(name) - 2, ".c") == 0) {
			name[strlen(name)-1] = 'o';
		}
		p = rindex(argv[i], '/');
		if (p == 0)
			strcpy(curdir, ".");
		else {
			p++;
			*p = 0;
			strcpy(curdir, argv[i]);
		}
		while (fgets(buf, sizeof(buf), fp) != 0) {
			if (*buf != '#')
				continue;
			p = buf+1;
			while (isspace(*p))
				p++;
			if (strncmp(p, "include", len) != 0)
				continue;
			quote = 0;
			bracket = index(p, '<');
			if (bracket != 0) {
				bracket++;
				end = index(bracket, '>');
				if (end == 0)
					continue;
				*end = 0;
				p = bracket;
			} else if ((quote = index(p, '"')) != 0) {
				quote++;
				end = index(quote, '"');
				if (end == 0)
					continue;
				*end = 0;
				p = quote;
			} else
				continue;
			if (*p == '/') {
				n = open(p, O_RDONLY, 0);
				if (n < 0) {
					fprintf(stderr, "%s: can't find %s\n",
						*argv, name);
					continue;
				}
				close(n);
				printf("%s: %s\n", name, p);
				continue;
			}
			if (quote != 0) {
				sprintf(fname, "%s/%s", curdir, p);
				if ((n = open(fname, O_RDONLY, 0)) > 0) {
					printf("%s: %s\n", name, fname);
					close(n);
					continue;
				}
			}
			if (look(includes, ni, p, 1))
				continue;
			if (look(defaults, nd, p, 0))
				continue;
			/*fprintf(stderr, "%s: can't find %s\n", *argv, name);*/
		}
		fclose(fp);
	}
	exit(0);
}

look(d, nd, p, pr)
	char	*d[];
	int	nd;
	char	*p;
	int	pr;
{
	char	fname[1024];
	int	n;
	int	i;

	for (i = 0; i < nd; i++) {
		sprintf(fname, "%s/%s", d[i], p);
		n = open(fname, O_RDONLY, 0);
		if (n > 0)
			break;
	}
	if (n > 0) {
		if (pr) printf("%s: %s\n", name, fname);
		close(n);
		return 1;
	}
	return 0;
}
