/*
 * Emulate BSD scandir(3) on HP-UX
 */
#ifdef hpux
#ifdef TEST_MAIN
#include <stdio.h>
#endif
#include <sys/types.h>
#define DIRSIZ_MACRO
#include <ndir.h>
#include <malloc.h>
#include <string.h>
#ifndef NULL
#define NULL 0
#endif
int
scandir(dirname, namelist, select, compar)
     char *dirname;
     struct direct *(*namelist[]);
     int (*select)();
     int (*compar)();
{
  DIR *dir = opendir(dirname);
  struct direct *entry;
  int i, n;
  if (dir == NULL)
    return -1;
  *namelist = malloc(2 * sizeof(**namelist));
  i = 0;
  n = 2;
  while ((entry = readdir(dir)) != NULL) {
    if (select == NULL || (*select)(entry)) {
      if (i == n)
    *namelist = realloc((char *)*namelist, (n *= 2) * sizeof(**namelist));
      (*namelist)[i] = malloc(DIRSIZ(entry));
      memcpy((*namelist)[i], entry, DIRSIZ(entry));
      ++i;
    }
  }
  closedir(dir);
  if (i == n)
      *namelist = realloc((char *)*namelist, (++n) * sizeof(**namelist));
  (*namelist)[i] = NULL;
  if (compar != NULL)
    qsort(*namelist, i, sizeof(**namelist), compar);
  return i;
}
int
alphasort(d1, d2)
     struct direct **d1, **d2;
{
  return strcmp((*d1)->d_name, (*d2)->d_name);
}
#ifdef TEST_MAIN
/*
 * print a sorted list of all .c files in a directory
 */
int
match(entry)
     struct direct *entry;
{
  return (entry->d_namlen > 2
      && entry->d_name[entry->d_namlen-1] == 'c'
      && entry->d_name[entry->d_namlen-2] == '.');
}
main(argc, argv)
     int argc;
     char **argv;
{
  struct direct **namelist, *p;
  if (argc != 2)
    fprintf(stderr, "Usage: %s directory\n", argv[0]), exit(1);
  scandir(argv[1], &namelist, match, alphasort);
  while (*namelist)
    printf("%s\n", (*namelist++)->d_name);
  exit(0);
}
#endif
#endif /* hpux */
