/*
 * sailio.h
 *
 * "standard-io"-like package for stream
 * sockets.  Yuck.
 *
 * Dave Pare, a986
 */

#define	_NSIO	20
#undef BUFSIZ
#define	BUFSIZ	2048

struct	sailbuf {
	int	i_cnt;
	int	o_cnt;
	char	*i_ptr;
	char	*o_ptr;
	char	*i_base;
	char	*o_base;
	int	i_bufsiz;
	int	o_bufsiz;
	int	flags;
	int	errno;
	char	fd;
};

#ifndef SAIL
#define	SAIL	struct sailbuf

extern SAIL *sailbuf;
# endif

SAIL	*sopen();

#define	sio_input(p)	((((p)->i_base + (p)->i_cnt) - (p)->i_ptr) > 0)
#define	sio_output(p)	((p)->o_cnt > 0)
#define	sio_ndelay(p) \
	((p)->fd |= fcntl((p)->fd, F_SETFL, FNDELAY) >= 0 ? _S_NDELAY : 0)

#define sio_fileno(p)	((p)->fd)
#define sio_eof(p)	((p)->flags & _S_EOF)
#define sio_err(p)	((p)->flags & _S_ERR)
#define sio_conn(p)	((p)->flags & _S_CONN)	/* true if no connection */
#define sio_timeout(p)	((p)->flags & _S_TO)
#define sio_flags(p)	((p)->flags & (_S_EOF|_S_ERR|_S_CONN|_S_TO))

#define sio_clrerr(p)	((p)->flags &= ~_S_ERR, p->errno = 0)
#define sio_clreof(p)	((p)->flags &= ~_S_EOF)
#define sio_clr(p)	((p)->flags &= ~(_S_ERR|_S_EOF|_S_TO|_S_CONN))
#define sio_errno(p)	((p)->errno)

#define	_S_NDELAY	0x1
#define	_S_EOF		0x2
#define	_S_ERR		0x4
#define _S_CONN		0x8
#define _S_TO		0x10

extern	char *sgets();
extern	SAIL *sopen();
