static char *RCSid = "$Header: userby.c,v 1.4 88/04/01 04:48:57 muir Locked $";

/*
 * $Log:	userby.c,v $
 * Revision 1.4  88/04/01  04:48:57  muir
 * rcsid now at top
 * 
 */

/*
 * userby.c
 *
 * fetch user struct by many different fields
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include "sailio.h"
#include "user.h"
#ifdef hpux
#include <memory.h>
#endif

extern	struct user users[];

struct user *
userbypid(pid)
	int	pid;
{
	register struct user *up;

	foreachuser (up) {
		if (*up->u_remhost == 0)
			continue;
		if (up->u_pid == pid)
			return up;
	}
	return 0;
}

struct user *
userbyfd(fd)
	int	fd;
{
	register struct user *up;

	foreachuser (up) {
		if (*up->u_remhost == 0)
			continue;
		if (up->u_iop && up->u_iop->fd == fd)
			return up;
	}
	return 0;
}

struct user *
userbycountry(up)
	struct	user *up;
{
	register struct user *p;

	foreachuser (p) {
		if (p == up)
			continue;
		if (*p->u_remhost == 0)
			continue;
		if (p->u_country == up->u_country && p->u_pid > 0)
			return p;
	}
	return 0;
}

deluser(up)
	struct	user *up;
{
	extern	int iswatching;

	if (up->u_stat == STAT_WATCH)
		iswatching--;
#ifdef hpux
	memset(up, 0, sizeof(*up));
#else
	bzero(up, sizeof(*up));
#endif
	up->u_country = -1;
	up->u_pid = -1;
	if (iswatching)
		dowatch();
	return 0;
}
