static char *RCSid = "$Header: servlog.c,v 1.3 88/04/01 04:48:39 muir Locked $";

/*
 * $Log:	servlog.c,v $
 * Revision 1.3  88/04/01  04:48:39  muir
 * rcsid now at top
 * 
 */

/*
 * servlog.c
 *
 * log a message, and put a timestamp on it.
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>

void servlog(str)
	char	*str;
{
	extern	char *ctime();
	extern	char *sys_errlist[];
	extern	int errno;
	extern	int sys_nerr;
	extern	int Log;
	char	buf[120];
	long	now;

	(void) time(&now);
	*buf = 0;
	if (str && *str) {
		strcpy(buf, str);
		strcat(buf, ": ");
	}
	if (errno > 0)
		strcat(buf, errno < sys_nerr ? sys_errlist[errno] :
			"Unknown error");
	strcat(buf, " ");
	strcat(buf, ctime(&now));
	(void) write(Log, buf, strlen(buf));
}

void servexit(p)
	char	*p;
{
	extern	int Log;

	servlog(p);
	(void) close(Log);
	(void) exit(1);
}
