static char *RCSid = "$Header: service.c,v 1.3 88/04/01 04:48:29 muir Locked $";

/*
 * $Log:	service.c,v $
 * Revision 1.3  88/04/01  04:48:29  muir
 * rcsid now at top
 * 
 */

/*
 * service.c
 *
 * service a user socket by reading all the
 * commands and executing the right routines.
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <errno.h>
#include "defs.h"
#include "sailio.h"
#include "user.h"

struct	fn {
	int	(*func)();
	char	*name;
	int	value;
};

extern	int quit();
extern	int coun();
extern	int pass();
extern	int user();
extern	int play();
extern	int list();
extern	int wat();

struct fn fnlist[] = {
	{ user,	"user",		USER,},
	{ coun,	"coun",		COUN,},
	{ quit,	"quit",		QUIT,},
	{ pass,	"pass",		PASS,},
	{ play,	"play",		PLAY,},
	{ list,	"list",		LIST,},
	{ wat,	"wat",		WAT,},
	{ NULL,	"",		0,},
};

int
service(up)
	struct	user *up;
{
	extern	void servlog();
	extern	struct user *deluser();
	extern	int errno;
	char	buf[80];
	char	cmd[20];

#ifdef DEBUG
	fprintf(stderr, "servicing %d\n", up->u_iop->fd);
#endif
	do {
		if (up->u_iop == 0) {
			fprintf(stderr, "help help u_iop is 0, up: %lx\n",
				up);
			break;
		}
		if (recvclient(up->u_iop, cmd, buf) == NULL)
			break;
		if (callfn(up, cmd, buf) > 0) {
			return 1;
		}
		sflush(up->u_iop);
		/*
		 * sio_input...in case more input exists
		 * on that line (i.e. multiple commands
		 * sent in one write() call from that client.
		 */
	} while (sio_input(up->u_iop) > 0);
	if (sio_conn(up->u_iop)) {
		sclose(up->u_iop);
		deluser(up);
		return 1;
	}
	return 0;
}

int
callfn(up, name, buf)
	struct	user *up;
	char	*name;
	char	*buf;
{
	extern	void sendclient();
	extern	int iswatching;
	struct	fn *fp;
	int	n;

	for (fp = fnlist; fp->func != NULL; fp++) {
		if (strcmp(fp->name, name) == 0)
			break;
	}
	if (fp->func == NULL) {
		sendclient(up->u_iop, C_BADCMD, "command not found");
		return 0;
	}
	up->u_cmd = fp->name;
	n = fp->func(up, buf);
	if (iswatching)
		dowatch();
	return n;
}

dowatch() {
	extern	struct user users[];
	register struct user *up;

	foreachuser (up) {
		if (up->u_stat == STAT_WATCH) {
			list(up);
			sflush(up->u_iop);
		}
	}
}
