static char *RCSid = "$Header: nat.c,v 1.3 88/04/01 04:47:49 muir Locked $";

/*
 * $Log:	nat.c,v $
 * Revision 1.3  88/04/01  04:47:49  muir
 * rcsid now at top
 * 
 */

/*
 * nat.c
 *
 * misc nation file access
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include <sys/file.h>
#undef R_OK
#include "nat.h"

struct	natstr _nat[MAX_MAXNOC];
static	int nat_fd = -1;

int
natbyname(name)
	char	*name;
{
	extern	char *natfil;
	struct	natstr nat;
	int	i;

	read_nat();
	for (i=0; i < MAX_MAXNOC; i++) {
		if (strcmp(_nat[i].nat_cnam, name) == 0)
			return i;
	}
	return -1;
}

natpass(cnum, pass)
	int	cnum;
	char	*pass;
{
	struct	natstr *np;

	read_nat();
	np = &_nat[cnum];
	if (np->nat_stat == STAT_VIS)
		return 1;
	if (strcmp(np->nat_pnam, pass) == 0)
		return 1;
	return 0;
}

init_nat() {
	extern	char *natfil;

	nat_fd = open(natfil, O_RDONLY, 0);
	if (nat_fd < 0) {
		char	buf[256];
		sprintf (buf,"cannot open nat file %s",natfil);
		servlog(buf);
		exit(1);
	}
}

read_nat()
{
	lseek(nat_fd, 0L, L_SET);
	read(nat_fd, _nat, sizeof(_nat));
}

write_nat()
{
	lseek(nat_fd, 0L, L_SET);
	write(nat_fd, _nat, sizeof(_nat));
}
