static char *RCSid = "$Header: main.c,v 1.5 88/12/16 19:55:47 muir Locked $";

/*
 * $Log:	main.c,v $
 * Revision 1.5  88/12/16  19:55:47  muir
 * 
 * before tml-patch-01
 * 
 * Revision 1.4  88/04/01  04:47:25  muir
 * rcsid now at top
 * 
 */

/*
 * main.c
 *
 * main command loop and initialization
 * for empire server
 *
 * Dave Pare, 1986
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include "gamesdef.h"
#include "defs.h"
#include "sailio.h"
#include "user.h"

extern	struct user users[];
int	savemask;
int	Log;

main() {
	extern	struct user *newuser();
	extern	struct user *userbyfd();
	extern	void servlog();
	extern	void sendclient();
	extern	void servexit();
	extern	int service();
	extern	char *rindex();
	extern	char *ctime();
	int	cleanchild();
	extern	char gamedir[];
	extern	char empire[];
	extern	short emp_port;
	extern	int errno;
	register struct user *up;
	char	logfile[80];
	char	buf[80];
	struct	sockaddr_in sin;
	struct	servent *sp;
	struct	hostent *hp;
	struct	timeval tv;
	char	host[32];
	FILE	*fp;
	int	mask;
	long	now;
	int	ns;
	int	s;
	short	port;
	int	val;

#ifndef DEBUG
	if (fork() != 0)
		exit(0);
	{ int s;
	for (s = 0; s < 10; s++)
		(void) close(s);
	}
	(void) open("/", O_RDONLY, 0);
	(void) dup(0, 1);
	(void) dup(0, 2);
#ifndef hpux
	{ int tt = open("/dev/tty", O_RDWR, 0);
	  if (tt > 0) {
		ioctl(tt, TIOCNOTTY, 0);
		close(tt);
	  }
	}
#endif
#endif

#ifdef KILLSERVER
#ifdef hpux
	srand(time());
#else
	srandom(time());
#endif
	{
		int	fds[2];
		extern	int killd;
		extern	int killfd;

		if (pipe(fds) < 0) {
			perror("pipe");
		}
		switch(killd=fork()) {
		case -1:
			perror("fork");
			exit(4);
		case 0:
			close (fds[1]);
			close(1);
			if (fds[0] != 0) dup2(fds[0],0);
			execl(KILLD,"killer",0);
			perror("execl");
			exit(5);
		default:
			close (fds[0]);
			killfd = fds[1];
			break;
		}
	}
#endif

	errno = 0;
	(void) sprintf(logfile, "%s/serverlog", gamedir);
	if ((Log = open(logfile, O_RDWR|O_CREAT|O_TRUNC, 0644)) <= 0) {
		(void) perror(logfile);
		(void) exit(1);
	}
#ifdef hpux
	(void) signal(SIGCLD, cleanchild);
#else
	(void) signal(SIGCHLD, cleanchild);
#endif
	(void) signal(SIGINT, SIG_IGN);
	(void) signal(SIGTSTP, SIG_IGN);
	(void) signal(SIGHUP, SIG_IGN);
	sp = getservbyname("empire", "tcp");
	if (sp == NULL)
		port = htons(emp_port);
	else
		port = sp->s_port;
	sin.sin_addr.s_addr = INADDR_ANY;
	sin.sin_port = port;
	sin.sin_family = AF_INET;
	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		servexit("inet socket create");
	val = 1;
	if (setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char *) &val, sizeof(val)) < 0)
		servexit("inet socket setsockopt SO_REUSEADDR");
	if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0)
		servexit("inet socket bind");
	if (listen(s, 5) < 0)
		servexit("inet socket listen");
	savemask = (1<<s);
	foreachuser (up) {
		up->u_country = -1;
	}
	init_nat();
	servlog(sprintf(buf, "server started, pid %d", getpid()));
	for (;;) {
		mask = savemask;
		if (select(32, &mask, (int *)0, (int *)0, (int *) 0) <= 0) {
			if (errno == EINTR)
				errno = 0;
			else
				servlog("main loop select");
			continue;
		}
		if (mask & (1<<s)) {
			up = newuser(s);
			if (up == 0) {
				servlog("newuser failed");
				continue;
			}
			savemask |= (1<<up->u_iop->fd);
			mask &= ~(1<<s);
		}
		while (mask) {
			int	fd;

			fd = ffs(mask) - 1;
			up = userbyfd(fd);
			if (up == 0) {
				servlog("cannot find user to match fd\n");
				close(fd);
				savemask &= ~(1<<fd);
				mask &= ~(1<<fd);
				continue;
			}
			/*
			 * if service returns true, then the
			 * user has left for the game and is
			 * currently logged in
			 */
			if (service(up))
				savemask &= ~(1<<fd);
			mask &= ~(1<<fd);
		}
	}
}

int
cleanchild() {
	extern	struct user *userbypid();
	extern	struct user *deluser();
	union	wait status;
	struct	user *up;
	char	buf[80];
	int	pid;

	while ((pid = wait3(&status, WNOHANG, NULL)) > 0) {
	    up = userbypid(pid);
	    if (up == 0) {
		    servlog(sprintf(buf,
			"recieved sigchld from a non-user child (%d)", pid));
		    return 0;
	    }
	    deluser(up);
	}
	return 0;
}
