static char *RCSid = "$Header: killd.c,v 1.5 88/07/21 21:37:25 muir Locked $";

/*
 * $Log:	killd.c,v $
 * Revision 1.5  88/07/21  21:37:25  muir
 * ooops, didn't quite get my fix correct.
 * 
 * 
 * Revision 1.4  88/07/21  19:55:55  muir
 * #ifdef to not bother with killd.c unless KILLSERVER is defined...
 * 
 * Revision 1.3  88/04/01  04:47:09  muir
 * rcsid now at top
 * 
 */

/*
 * kill server
 *
 * handles ^C's typed by the client.  Needed for those
 * stupid systems w/o oob messages.
 *
 * David Muir Sharnoff, 1987
 */

#ifdef KILLSERVER

#include <stdio.h>
#include <strings.h>
#include <signal.h>
#include <errno.h>
#ifdef hpux
#include <sys/types.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "defs.h"
#include "misc.h"

#define	MAXPID	MAXNOC+10

#define	LOGFILE "../killd_log"

#define DEBUG

extern	void	handle(), insecure(), secure(), addcode(), delcode(), clean(),
		sigcode();

main()
{
	struct sockaddr_in sin, from;
	int	size;
	extern	int errno;
	int	s;
	int	fd;
	int	fromlen;
	char	buf[BUFSIZ];


	fd = open(LOGFILE,O_WRONLY|O_CREAT|O_TRUNC,0600);
	if (fd < 0) {
		perror("open logifle");
		exit(-1);
	}
	if (fd != 1) { close(1); dup2(fd,1); }
	if (fd != 2) { close(2); dup2(fd,2); }
	setbuf(stdout,NULL);
	puts("kill server started\n");

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	sin.sin_port = KILL_PORT;

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s < 0) {
		perror("dg socket");
		exit(1);
	}

	if (bind(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("bind");
		exit(1);
	}

	signal(SIGURG,handle);

	for(;;) {
		fromlen = sizeof(from);
		size = recvfrom(s,buf,BUFSIZ,0,&from,&fromlen);

		if (size < 0 && errno != EINTR) {
			perror("recv");
			sleep(1);
		}
		if (size >0) {
			/* 
			 * send the message back so we know it got
			 * there ok.
			 */
			sendto(s,buf,size,0,&from,fromlen);

			buf[size] = '\0';
			insecure(buf);
		}
	}
}


void
handle(sig)
         int sig;
{
	char	buf[BUFSIZ];
	int	size;
	int	a[2];

	size = read(0,a,sizeof(a));
	if (size != sizeof(a)) {
		printf("bad read from empserver, %d bytes\n",size);
	} else {
		addcode(a[0],a[1]);
	}
}

void
insecure(msg)
	char	*msg;
{
	switch (*msg++) {
	case 'e':
		delcode(atoi(msg));
		break;
	case 's':
		sigcode(atoi(msg));
		break;
	default:
		printf("invalid message\n");
#ifdef DEBUG
		{
			int i;
			extern	int pids[], codes[];

			for (i = 0; i < 10; i++) {
				printf("\t%d\t%d\t%d\n",i,pids[i],codes[i]);
			}
		}
#endif
		break;
	}
}

int	pids[MAXPID];
int	codes[MAXPID];
int	npids;

void
addcode(pid,code)
	int	pid,code;
{
	int	i;

	for (i = 0; pids[i] != 0 && i < MAXPID-1; i++);
	pids[i] = pid;
	codes[i] = code;
	if (++npids > MAXPID -5) clean();
#ifdef	DEBUG
	printf("add entry %d, pid %d, code %d\n",i,pid,code);
#endif
}

void
delcode(code)
	int	code;
{
	int	i;

	for (i = 0; codes[i] != code && i < MAXPID; i++);
	pids[i] =0;
	--npids;
#ifdef DEBUG
	printf("delete code %d, entry %d\n",code,i);
#endif

}

void
sigcode(code)
	int	code;
{
	int	i;

	for (i = 0; codes[i] != code && i < MAXPID; i++);
	
	if(i == MAXPID || pids[i]==0) {
		printf("illegal reqest, code %d\n",code);
		return;
	}
#ifdef DEBUG
	printf("signal %d, entry %d, code %d\n",pids[i],i,code);
#endif
	kill(pids[i],SIGUSR1);
}

void
clean()
{
	int	i;
	
	printf("startclean %d\n",npids);
	for (i = 0; i < MAXPID; i++) {
		if (pids[i]) {
			if (kill(pids[i],SIGUSR2)) {
				printf("process %d dead\n",pids[i]);
				pids[i] = 0;
				--npids;
			}
		}
	}
	if (npids >MAXPID-5) printf("problems! pids = %d\n",npids);
	printf("endclean %d\n",npids);
}

#else /* KILLSERVER */
	main(){exit(0);}
#endif /* KILLSERVER */
