static char *RCSid = "$Header: /n/postgres/a/postgres/muir/empire/empmain/RCS/empglb.c,v 1.41 89/01/15 11:20:54 muir Exp $";

/*
 * strglb.c
 *
 * Empire global "characteristic" structures; things like
 * pchr, mchr, nchr, plchr, etc.
 * 
 */

#include "misc.h"
#include "var.h"
#include "xy.h"
#include "item.h"
#include "nat.h"
#include "nuke.h"
#include "plane.h"
#include "ship.h"
#include "product.h"
#include "treaty.h"
#include "news.h"
#include "sect.h"

#include	"gamesdef.h"

#define OS(x)	((long) (&((struct sctstr *) 0) -> x))
#define SO(x)	((long) (&((struct shpstr *) 0) -> x))
#define PO(x)	((long) (&((struct plnstr *) 0) -> x))

/*    designation characteristics -- one entry per designation type
 *	order must agree with sect.h
 */
struct  dchrstr dchr[]  = {
/*      mnem prd     mcst  flg    pkg ostr dstr value name    */
	'.', 0,        0, NAVOK,  NPKG,  0,   0,   0, "sea",
	'^', 0,      127, 0,      NPKG,  2,  16,   5, "mountain",
	's', 0,        0, 0,      NPKG,  0,  99, 127, "sanctuary",
	'\\',0,        0, 0,      NPKG,  0,  99,   0, "wasteland",
	'-', 0,        4, 0,      NPKG,  2,   2,   1, "wilderness",
	'c', 0,        2, 0,      NPKG,  2,   4,  30, "capital",
	'u', P_URAN,   2, 0,      NPKG,  2,   3,  15, "uranium mine",
	'p', P_HLEV,   2, 0,      NPKG,  2,   2,   5, "park",
	'd', P_GUN,    2, 0,      NPKG,  2,   2,   7, "defense plant",
	'i', P_SHELL,  2, 0,      NPKG,  2,   2,   6, "shell industry",
	'm', P_IRON,   2, 0,      NPKG,  2,   3,   5, "mine",
	'g', P_DUST,   2, 0,      NPKG,  2,   3,   8, "gold mine",
	'h', 0,        2, NAV_02, NPKG,  2,   2,  12, "harbor",
	'w', 0,        2, 0,      WPKG,  2,   2,   7, "warehouse",
	'*', 0,        2, 0,      NPKG,  2,   1,  12, "airfield",
	'a', P_FOOD,   2, 0,      NPKG,  2,   2,   2, "agribusiness",
	'o', P_OIL,    2, 0,      NPKG,  2,   2,   5, "oil field",
	'j', P_LCM,    2, 0,      NPKG,  2,   2,   3, "light manufacturing",
	'k', P_HCM,    2, 0,      NPKG,  2,   2,   4, "heavy manufacturing",
	'f', 0,        2, 0,      NPKG,  4,   8,  10, "fortress",
	't', P_TLEV,   2, 0,      NPKG,  2,   2,  10, "technical center",
	'r', P_RLEV,   2, 0,      NPKG,  2,   2,   9, "research lab",
	'n', 0,        2, 0,      NPKG,  2,   3,  10, "nuclear plant",
	'l', P_ELEV,   2, 0,      NPKG,  2,   2,   4, "library/school",
	'+', 0,        1, 0,      NPKG,  1,   1,   3, "highway",
	')', 0,        2, 0,      NPKG,  2,   2,   4, "radar installation",
	'!', 0,        2, 0,      NPKG,  2,   2,   1, "weather stn (useless)",
	'#', 0,        2, 0,      NPKG,  2,   2,   4, "bridge head",
	'=', P_FOOD,   1, NAV_60, NPKG,  1,   1,   5, "bridge span",
	'b', P_BAR,    2, 0,      BPKG,  2,   3,  10, "bank",
	'%', P_PETROL, 2, 0,      NPKG,  2,   2,   2, "refinery",
	'e', 0,        2, 0,      NPKG,  2,   3,   7, "enlistment center",
	0,   0,        0, 0,      0,     0,   0,   0, 0,
};	/* if you add sects be sure to increase the definition of sct_maxno */

/*      
 * item characteristics -- one entry per movable item
 *
 * must be in same order as defines in var.h
 *
 */
struct  ichrstr ichr[]  = {
/*      mnem vtype     val sell  lbs rg,wh,ur,bnk  name */
	'?', 0,         0,   0,   0, 0, 0, 0, 0, "unused",
	'c', V_CIVIL,   1,   0,   1, 1, 1,10, 1, "civilians",
	'm', V_MILIT,   0,   0,   1, 1, 1, 1, 1, "military",
	's', V_SHELL,   5,   1,   2, 1,10, 1, 1, "shells",
	'g', V_GUN,     60,  1,   10,1,10, 1, 1, "guns",
	'p', V_PETROL,  4,   1,   1, 1,10, 1, 1, "petrol",
	'i', V_IRON,    2,   1,   1, 1,10, 1, 1, "iron ore",
	'd', V_DUST,    20,  1,   5, 1,10, 1, 1, "dust (gold)",
	'b', V_BAR,     280, 1,   50,1, 5, 1, 1, "bars of gold",
	'f', V_FOOD,    0,   1,   1, 1,10, 1, 1, "food",
	'o', V_OIL,     8,   1,   1, 1,10, 1, 1, "oil",
	'l', V_LCM,     2,   1,   1, 1,10, 1, 1, "light products",
	'h', V_HCM,     4,   1,   1, 1,10, 1, 1, "heavy products",
	'u', V_UW,      1,   1,   2, 1, 1, 1, 1, "uncompensated workers", 
	'r', V_RAD,	150, 1,   8, 1,10, 1, 1, "radioactive materials",
  	 0,  0,         0,   0,   0, 0, 0, 0, 0, 0,
};

int maxitem = sizeof(ichr)/sizeof(struct ichrstr);

struct pchrstr pchr[]  = {   /* order must agree with P_ defines */
	/* NOTE: V(V_xxx) entries must be in numerical order */
/*       level      cost    nrndx nrdep nlndx   nlmin nllag effic  sname name */
{0,       0,         0,      0,    0,    0,        0,    0,  0,    
	"unused", 0, { 0 }, { 0 }, "", },
{V_SHELL, -1,        3,      0,    0,    NAT_TLEV, 20,  10, 100, 
	"shells", 2, { V_LCM, V_HCM}, { 2, 1 },  "shells", },
{V_GUN,   -1,        30,     0,    0,    NAT_TLEV, 20,  10, 100, 
	"guns", 3, { V_OIL, V_LCM, V_HCM }, { 1, 5, 10 },  "guns",},
{V_PETROL,-1,        1,      0,    0,    NAT_TLEV, 20,  10, 1000,
	"petrol", 1, { V_OIL }, { 1 },  "petrol",},
{V_IRON,  -1,        0,OS(sct_min),0,    -1,       0,    0,  100,
	"iron ore", 0, { 0 }, { 0 },  "iron",	},
{V_DUST,  -1,        0,OS(sct_gmin),20,  -1,       0,    0,  100,
	"gold dust", 0, { 0 }, { 0 },  "dust",},
{V_BAR,   -1,        10,     0,    0,    -1,       0,    0,  100, 
	"gold bars", 1, { V_DUST }, { 5 }, "bars",},
{V_FOOD,  -1,        0,OS(sct_fertil),0, NAT_TLEV, -10,  10, 900,
	"food", 0, { 0 }, { 0 }, "food",},
{V_OIL,   -1,        0,OS(sct_oil),10,   NAT_TLEV, -10,  10, 100, 
	"oil", 0, { 0 }, { 0 }, "oil",},
{V_LCM,   -1,        0,      0,    0,    NAT_TLEV, -10,  10, 100,
	"light construction materials", 1, { V_IRON }, { 1 }, "lcm",},
{V_HCM,   -1,        0,      0,    0,    NAT_TLEV, -10,  10, 100,
	"heavy construction materials", 1, { V_IRON }, { 2 },  "hcm", },
{0,       NAT_TLEV, 90,     0,    0,    NAT_ELEV, 5,    10, 100,
      "technological breakthroughs",3,{V_DUST,V_OIL,V_LCM}, {1,5,10}, "tech",},
{0,       NAT_RLEV, 90,     0,    0,    NAT_ELEV, 5,    10, 100,
      "medical discoveries",3,{V_DUST,V_OIL,V_LCM }, { 1, 5, 10 }, "medical",},
{0,       NAT_ELEV,  9,     0,    0,    -1,       0,    0,  100,
	"a class of graduates", 1, { V_LCM }, { 1 },  "edu",},
{0,       NAT_HLEV,  9,     0,    0,    -1,       0,    0,  100,
	"happy strollers", 1, { V_LCM }, { 1 },  "happy",},
{V_RAD, -1,          2,OS(sct_uran),35, NAT_TLEV, 40,  10, 100, 
	"radioactive materials", 0, { 0 }, { 0 },  "rad",},
};

/*	marine characteristics -- one entry per ship type */
struct  mchrstr mchr[]  = { /*
 lcm  hcm armor speed visib vrnge frnge glim name   		tech	cost */
 25,  15,  10,   20,   15,    2,    0,    0, "fishing boat",	0,	200,
    M_FOOD, 4, { V_CIVIL, V_MILIT, V_FOOD, V_UW }, { 30, 5, 100, 15 },
 80,  30,  20,   40,   20,   10,    0,    0, "fishing trawler",	180,	6000,
    M_FOOD|M_SONAR, 3, { V_CIVIL, V_MILIT, V_FOOD }, { 25, 10, 120 },
 60,  40,  50,   25,   35,    3,    0,    0, "cargo ship",	0,	600,
    0, 8, { V_CIVIL, V_MILIT, V_SHELL, V_GUN, V_FOOD, V_LCM, V_HCM, V_UW },
	{ 50, 50, 300, 50, 900, 1400, 900, 250 },
 40,  40,  20,   70,   17,    5,    0,    0, "yacht",		220,	2500,
    M_LAND, 4, { V_CIVIL, V_MILIT, V_FOOD, V_UW }, { 60, 30, 20, 30 },
 40,  40,  80,   25,   60,    3,    0,    0, "tanker",		50,	4000,
    0, 6, { V_CIVIL, V_MILIT, V_PETROL, V_FOOD, V_OIL, V_UW },
	{ 30, 5, 990, 200, 990, 25 },
 50,  50, 127,   10,   80,    4,    0,    0, "oil derrick",	120,	2000,
    M_OIL, 5, { V_CIVIL, V_MILIT, V_FOOD, V_OIL, V_UW },
	{ 80, 80, 300, 200, 180 },
 20,  10,  30,   50,   10,    4,    1,    1, "patrol boat",	40,	350,
    0, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD }, { 10, 10, 2, 30 },
 25,  25,  60,   30,   20,    3,    1,    1, "minesweep",	20,	550,
    M_SWEEP, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD }, { 25, 60, 2, 25 },
 20,  30,  70,   30,   15,    3,    2,    2, "guided missile frigate",130,1500,
    M_MSL, 5, { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD }, 
	{  50, 30, 3, 100, 70 },
 25,  35,  80,   35,   20,    4,    3,    2, "destroyer",	20,	1100,
    M_MINE|M_SONAR|M_DCH, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD },
	{ 80, 40, 4, 80 },
 40,  40,  30,   30,   30,    2,    0,    0, "landing ship",	70,	1200,
    M_LAND, 2, { V_MILIT, V_FOOD }, { 400, 300 },
 40,  50, 100,   30,   30,    5,    6,    3, "heavy cruiser",	40,	3000,
    M_MINE, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD }, { 120, 60, 6, 100 },
 55,  65, 127,   30,   35,    6,    8,    4, "battleship",	50,	4000,
    0, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD }, { 200, 100, 8, 300 },
 70,  65,  80,   30,   35,    8,    2,    2, "aircraft carrier",60,	4400,
    M_FLY, 5, { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD },
	{ 350, 350, 4, 500, 180},
 40,  30,  30,   25,    2,    3,    2,    2, "submarine",	70,	2200,
    M_SUB|M_TORP|M_MINE|M_SONAR, 4, { V_MILIT, V_SHELL, V_GUN, V_FOOD },
	{ 25, 25, 4, 40 },
 90,  60,  30,   50,    1,    3,    0,    8, "nuclear sub",	320,	4000,
    M_SUB|M_TORP|M_SONAR|M_MSL, 5, { V_MILIT, V_SHELL, V_GUN, V_PETROL, V_FOOD},
	{ 30, 24, 4, 60, 500 },
 20,  40,   5,   10,   15,    3,    0,    0, "refugee boat",	3,	300,
    0, 3, { V_CIVIL, V_MILIT, V_FOOD, V_UW }, { 80,  5,  10, 600 },
 60,  40,  20,   25,   25,    3,    0,    0, "slave ship",	8,	1000,
    0, 4, { V_CIVIL, V_MILIT, V_FOOD, V_UW }, { 20, 80, 200, 600 },
 40,  40,  40,   25,   50,    3,    0,    0, "ore ship",        25,     2000,
     0, 7, { V_CIVIL, V_MILIT, V_IRON, V_DUST, V_FOOD, V_UW, V_RAD },
        { 30, 5, 990, 990, 200, 45, 990 },
  0,   0,   0,    0,    0,    0,    0,    0, "", 		0, 	0,
    0, 0, { 0 }, { 0 },
};

int	shp_maxno = (sizeof(mchr) / sizeof(struct mchrstr)) - 1;

/*
 * plane characteristics
 * flags indicate capabilities of craft...
 * P_T: tactical, P_F: fighter/interceptor, P_B: bomber,
 * P_C: cargo, P_G: glider, P_V: vtol, P_M: (one-shot) missile
 * P_L: light, can land on carriers.
 */
struct plchrstr plchr[] = {
/*       name          lcm hcm $$$ tech acc load att/def ran mil gas flags */
	"fighter 1",	 8, 2, 400, 40, 30,  0,  3,  2,  4,  1,  1, P_T|P_F|P_L,
	"lt bomber 1",	10, 3, 550, 40, 30,  1,  1,  2,  5,  2,  1, P_T|P_B|P_L,
	"transport 1",	12, 5, 800, 45,  0,  9,  0,  1,  8,  2,  2, P_C,
	"hvy bomber 1",	20, 6,1100, 50, 90,  5,  2,  3,  9,  3,  2, P_B,
	"long bomber 1",20, 6,1100, 60,120,  2,  0,  1, 30,  4,  4, P_B,
	"fighter 2",	10, 6, 800, 70, 25,  1,  6,  4,  8,  1,  1, P_T|P_F|P_L,
	"lt bomber 2",	12, 8, 900, 70, 25,  2,  2,  3, 10,  2,  1, P_T|P_B|P_L,
	"escort 2",	12, 5, 850, 75, 25,  1,  5,  4, 14,  1,  2, P_L,
	"chopper 1",	10, 4, 900, 75,  0,  3,  0,  2,  6,  1,  1, P_C|P_V|P_L,
	"transport 2",	14,10,1200, 80,  0,  9,  0,  3, 20,  3,  3, P_C,
	"long transport",14,10,1200,80,  0,  3,  0,  1, 35,  5,  7, P_C,
	"hvy bomber 2",	20,15,2000, 90, 75,  9,  4,  5, 20,  5,  3, P_B,
	"long bomber 2",20,15,2000,100, 75,  4,  2,  2, 40,  8,  8, P_B,
	"jet fighter",	16, 5,2000,120, 40,  2, 12,  8,  8,  1,  3, P_T|P_F|P_L,
	"jet lt bomber",14, 7,1200,120, 20,  5,  5,  8, 14,  2,  3, P_T|P_B|P_L,
	"jet hvy bomber",35,20,5500,140,60, 16,  5, 11, 44,  5,  5, P_B,
	"jet transport",30,20,1700,140,  0, 16,  0,  6, 40,  3,  5, P_C,
	"jet fighter 2",16, 5,2000,200, 30,  2, 11,  7,  8,  1,  3, P_T|P_F|P_V|P_L,
	"jet escort",	12, 5,1000,230, 99,  2, 11,  6, 36,  7,  5, 0,
	"chopper 2",	15, 8,1000,180,  5,  5,  4,  4, 12,  1,  1, P_T|P_B|P_V|P_L,
	"chopper 3",	15,12,1100,180,  0,  5,  2,  3, 16,  2,  1, P_C|P_V|P_L,
	"chopper 4",	15,12,1500,265,  8,  5,  5,  3, 16,  2,  1, P_T|P_B|P_C|P_V|P_L,
	"tac missile 1",10, 5, 500,160, 80,  4,  0,  5,  8,  0,  5, P_M|P_L,
	"tac missile 2",12, 8, 600,180, 70,  6,  0,  6, 10,  0,  6, P_M|P_L,
	"irbm 1",	15,15,1000,250, 60,  5,  0,  3, 15,  0,  7, P_M,
	"irbm 2",	18,18,2000,270, 50,  7,  0,  3, 18,  0,  8, P_M,
	"icbm 1",	30,30,3000,280, 70,  7,  0,  3, 40,  0,  9, P_M,
	"icbm 2",	45,45,4000,320, 50, 10,  0,  6, 50,  0, 10, P_M,
	"icbm 3",	60,60,5000,400, 20, 15,  0, 10, 60,  0, 11, P_M,
	"icbm 4",     100,100,9000,450, 20, 30,  0, 50 ,60,  0, 12, P_M,
	"slbm 1",	25,25,3000,260, 70,  7,  0,  3, 19,  0,  6, P_M|P_L,
	"slbm 2",	25,25,5000,360, 70, 11,  0,  3, 40,  0,  7, P_M|P_L,
	"sam 1",	25,25,300, 130, 30,  4, 12,  1,  5,  0,  6, P_M|P_F,
	"sam 2",	35,35,500, 230, 20,  4, 12,  1,  5,  0,  6, P_M|P_F|P_L,
	"sam 3",	45,45,1600,380, 10,  4, 14,  1, 15,  0,  6, P_M|P_F,
	"sam 4",	45,45,2000,480, 10,  4, 14,  1, 15,  0,  6, P_M|P_F|P_L,
	"spyplane 1",	15,10,3000,190,  0,  0,  0,  5, 48,  1,  5, P_S,
	"spyplane 2",	18,13,5000,275,  0,  0,  0,  8, 75,  5,  9, P_S|P_I,
	"landsat 1"	,20,20,8000,205, 0,  0,  0,  2, 99,  0,  9, P_O,
	"landsat 2"	,25,25,9500,305, 0,  0,  0,  2, 99,  0,  9, P_O|P_I,
	"spysat 1"	,30,30,25000,405,0,  0,  0,  2, 99,  0,  9, P_O|P_S,
	"spysat 2"	,35,35,30000,505,0,  0,  0,  2, 99,  0,  9, P_O|P_S|P_I,
	"stealth bomber",45,35,9500,450,75, 12,  3,  9, 36,  3,  4, P_B|P_X,
	"stealth fighter",35,25,9500,450,50, 2,  8,  6, 20,  1,  3, P_T|P_X,
	"anti-sat 1",  13, 8,  700,185, 70,  6,  0,  6,  8,  0,  4, P_O|P_M|P_L,
	"anti-sat 2",  15, 8,  800,235, 60,  8,  0,  6, 12,  0,  5, P_O|P_M|P_L,
	"anti-sat 3",  18, 8,  900,285, 50,  8,  0,  6, 20,  0,  6, P_O|P_M|P_L,
	"anti-sat 4",  35,35, 2500,335, 40, 16,  0,  6, 99,  0,  9, P_O|P_M,
	"",		0, 0,    0,  0,  0,  0,  0,  0,  0,  0,  0, 0,
/*       name          lcm hcm $$$ tech acc load att/def ran mil gas flags */
};

int	pln_maxno   = (sizeof(plchr) / sizeof(struct plchrstr)) - 1;

struct nchrstr nchr[] = {
	/* name         lcm  hcm  oil  rads blst dam    cost  tech lbs flags */
	"5kt fission",   25,  25,  15,  10,  2,   70,   5000,  265,  1,   0,
	"10kt fission",	 50,  50,  25,  50,  3,   80,   7500,  200,  4,   0,
	"15kt fission",	 50,  50,  25,  15,  2,   90,   7500,  335,  2,   0,
	"50kt fission",	 60,  60,  30,  75,  3,  100,   9000,  225,  6,   0,
	"100kt fission", 75,  75,  40, 100,  4,  120,  12000,  250,  8,   0, 
	"250kt fusion",	 50,  50,  25,  50,  4,  150,   7500,  280,  4,   0,
	"500kt fusion",  60,  60,  30,  75,  5,  170,   9000,  295,  6,   0,
	"1mt fusion",	 75,  75,  50, 100,  6,  190,  12000,  310,  8,   0,
	"3mt fusion",	100, 100,  75, 135,  7,  210,  17000,  325, 10,   0,
    	"5mt fusion", 	120, 120, 100, 160,  8,  230,  29000,  350, 15,   0,
    /*"50kt neutron",	 60,  60,  30,  75,  3,  100,   9000,  325,  2,   0,*/
    /*"100kt neutron", 75,  75,  40, 100,  4,  120,  12000,  345,  3,   0,*/
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
	"",		  0,   0,   0,   0,  0,    0,      0,    0,  0,   0,
};

int	nuk_maxno = (sizeof(nchr) / sizeof(struct nchrstr)) - 1;

/*   treaty clause characteristics -- one entry per possible treaty clause */
struct  tchrstr tchr[]  = {
	SEAATT,	"no attacks on any ships",
	SEAFIR,	"no shelling any ships",
	LANATT,	"no sector attacks",
	LANFIR,	"no shelling any land",
	NEWSHP,	"no building ships",
	NEWNUK,	"no new nuclear weapons",
	NEWPLN,	"no building planes",
	TRTENL,	"no enlistment",
	0,      0,
};

/* report -- one entry per type of news item (order agrees with news verbs) */
struct  rptstr rpt[]    = {
/*  nice    page    text
*/  0,      3,      "does nothing in particular to %s",
		    "does nothing to %s",
    -4,     1,      "infantry capture %s territory",
		    "shock troops overrun one of %s's sectors",
    -4,     1,      "infantry beaten back by %s troops",
		    "shock troops annihilated in failed attack on %s",
    -1,     2,      "spy shot by %s firing squad",
		    "spy captured and shot by %s",
    1,      2,      "sends a telegram to %s",
		    "telexes %s",
    3,      3,      "diplomats sign a treaty with %s",
		    "ambassador agrees to a treaty with %s",
    2,      3,      "bankers make a loan to %s",
		    "Ministry of Finance lends money to %s",
    1,      3,      "repays a loan from %s",
		    "makes last payment on loan from %s",
    0,      3,      "makes a sale to %s",
		    "sells goods to %s",
    -1,     1,      "violates %s airspace",
		    "overflies %s territory",
    -2,     1,      "gunners bombard %s territory",
		    "artillery fires on %s sectors",
    -2,     1,      "shells a ship owned by %s",
		    "fires on %s ships",
    0,      2,      "takes over unoccupied land",
		    "attacks unowned land for some reason",
    0,      1,      "ships torpedoed by enemy wolf-packs",
		    "ships torpedoed by marauding U-boats",
    0,      1,      "gunners fire on %s in self-defense",
		    "gunners decimate %s aggressors",
    0,      2,      "breaks sanctuary",
		    "no longer has a sanctuary",
    -2,     1,      "planes divebomb one of %s's sectors",
		    "bombers wreak havoc on %s",
    -2,     1,      "divebombs a ship flying the flag of %s",
		    "airforce bombs %s ships",
    -2,     1,      "seadogs board one of %s's ships",
		    "pirates board %s ship",
    -3,     1,      "is repelled by %s while attempting to board a ship",
		    "pirates prove inept at boarding %s's ships",
    -1,     1,      "anti-aircraft gunners fire on %s airforce",
		    "attempts to shoot down %s aircraft",
    -2,     3,      "seizes a sector from %s to collect on a loan",
		    "collects one of %s's sectors in repayment of a loan",
    -1,     2,      "considers an action which would violate a treaty with %s",
		    "decides not to violate treaty with %s (yet)",
    -4,     1,      "violates a treaty with %s",
		    "actions violate treaty with %s",
    0,      1,      "disolves its government",
		    "throws in the towel",
    0,      1,      "ship hits a mine",
		    "ship severely damaged in mine field",
    5,      1,      "announces an alliance with %s",
		    "/ %s alliance declared",
    0,      1,      "declares their neutrality toward %s", /* no longer used */
		    "announces neutral relations with %s",
    -5,     1,      "declares TOTAL WAR on %s",
		    "gets serious with %s and declares WAR",
    -5,     1,      "diplomats disavow former alliance with %s",
		    "is no longer allied with %s",
    5,      1,      "is no longer at war with %s",
		    "Foreign Ministry declares \"No more war with %s\"",
    0,      1,      "reports outbreak of the black plague",
		    "sector infected with bubonic plague",
    0,      2,      "citizens die from bubonic plague",
		    "sector reports plague deaths",
    0,      2,      "goes through a name change",
		    "adopts a new country name",
    0,      2,      "citizens starve in disastrous famine",
		    "loses citizens to mass starvation",
    0,      2,      "endures lawless rioting",
		    "suffers from outbreaks of rioting",
    -3,     1,      "pilots down %s planes",
			"victorious in air-to-air combat against %s",
    -10,    1,      "nuclear device devastates %s sector",
		    "explodes a nuclear device damaging %s territory",
    0,      1,      "terrorists shoot it out with %s special forces",
		    "underground rises up against %s occupation",
    -2,     1,      "execution squads gun down helpless %s civilians",
		    "firing squads massacre defenseless %s workers",
     0,     1,      "launches a satellite into orbit",
		    "continues its conquest of space with a successful launch",
    -8,     1,      "strike a %s big bird",
		    "rockets damage a %s satellite",
     4,     1,      "makes a contribution to %s",
		    "helps out %s",
     2,     1,      "aids %s with divine intervention",
		    "smiles upon %s",
    -3,     1,      "hurts %s with divine intervention",
		    "frowns upon %s",
    -4,     1,      "sacrifices to %s",
		    "makes divine payment to %s",
    0,      0,      0
};

int   n_max_verb  = N_MAX_VERB;
