/*
 * saber.c
 *
 * Files for emulation of the tm using saber
 *
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

struct	sockaddr_un tm_un;
int	tm_s;

int
tm_setup()
{
	extern	char gamedir[];

	sprintf(tm_un.sun_path, "%s/tm_socket", gamedir);
	unlink(tm_un.sun_path);
	tm_un.sun_family = AF_UNIX;
	if ((tm_s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		return 0;
	}
	if (bind(tm_s, &tm_un, 2 + strlen(tm_un.sun_path)) < 0) {
		perror("bind");
		return 0;
	}
	listen(tm_s, 5);
	return tm_s;
}

int
tm_new()
{
	int	len;

	len = strlen(tm_un.sun_path) + 2;
	return accept(tm_s, &tm_un, &len);
}
