static char *RCSid = "$Header: /n/postgres/a/postgres/muir/empire/empmain/RCS/init_nats.c,v 1.12 88/12/18 16:42:07 muir Exp $";

/*
 * init_nats.c
 *
 * initialize country and nation file stuff.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "file.h"
#include "deity.h"

init_nats()
{
	struct	natstr *np;
	extern	long curup;

	if ((np = getnatp(cnum)) == 0)
		bye_bye(-1);
	nstat = np->nat_stat;
	god = np->nat_stat & STAT_GOD;
	if (np->nat_money <= 0)
		broke = 1;
	else {
		nstat |= MONEY;
		broke = 0;
	}
	nat_cap(np->nat_btu);
}

nat_cap(btu)
	int	btu;
{
	extern	int s_p_etu;
	extern	int max_btus;
	extern	float btu_build_rate;
	struct	sctstr sect;
	struct	natstr *np;
	double	d;
	double	civ;
	int	delta;

	np = getnatp(cnum);
	if (!getsect(np->nat_xcap, np->nat_ycap, &sect)) {
		logerror("can't read %d,%d", np->nat_xcap, np->nat_ycap);
		bye_bye(1);
	}
	if ((nstat & NORM) == NORM) {
		if (owner && (sect.sct_type == SCT_CAPIT ||
		    sect.sct_type == SCT_SANCT))
			nstat |= CAP;
		else
			nstat &= ~CAP;
	}
	delta = 0;
	if ((nstat & CAP) || god) {
		d = (double) (curup - np->nat_date) / s_p_etu;
		if (d > 336.0)
			d = 336.0;
		civ = getvar(V_CIVIL, (caddr_t)&sect, EF_SECTOR);
		if (civ > 999)
			civ = 999;
		delta = roundavg(((d * civ) * sect.sct_effic) * btu_build_rate);
		if (god)
			delta = max_btus-btu;
		if (delta + btu > max_btus)
			delta = max_btus - btu;
		if (btu > max_btus)
			delta = max_btus - btu;
		NAT_DELTA(nat_btu, cnum, delta);
	}
	NAT_SET(nat_date, cnum, curup);
	return btu + delta;
}
