#ifndef lint
static char *RCSid = "$Header: parse.c,v 1.4 88/08/19 12:41:02 muir Locked $";
#endif

/*
 * parse.c
 *
 * parse empire command line, chop into argp
 * If values argpp and spacep passed, parse will use them.
 * otherwise, parse will use static space and global argp.
 * parse assumes that argpp is a char *buf[16], and that spacep
 * points to a buf of at least 256 bytes.
 *
 * from PSL Empire, 1985
 */

static char static_space[512];

int
parse(buf, argpp, condp, space)
	register char *buf;	/* register r11 */
	char	**argpp;
	char	**condp;
	char	*space;
{
	register char *bp2;
	register char *bp1;
	register char **arg;
	int	fs;
	int	argnum;

	bp1 = space == 0 ? static_space : space;
	arg = argpp;
	if (condp != 0)
		*condp = 0;
	for (argnum=0; *buf && argnum < 16; ) {
		arg[argnum] = bp1;
		argnum++;
		while (*buf == ' ')
			buf++;
		if (*buf == '"')
			fs = *buf++;
		else
			fs = ' ';
		for (bp2 = bp1; *buf; ) {
			if (*buf == fs)
				break;
			*bp1++ = *buf++;
		}
		*bp1++ = 0;
		if (*bp2 == '?' && condp != 0) {
			*condp = bp2 + 1;
			argnum--;
		}
	}
	for (fs = argnum; fs < 16; fs++)
		arg[fs] = 0;
	return argnum;
}
