/*
 * lock.c
 *
 * lock a file
 *
 */

#include "misc.h"
#include <sys/file.h>
#ifdef hpux
#include <unistd.h>
#endif

int
file_lock(fd)
	int	fd;
{
#ifdef hpux
	if (lockf(fd, F_LOCK, 0) == 0)
#else
	if (flock(fd, LOCK_EX) == 0)
#endif
		return 0;
	logerror("file lock failed");
	return -1;
}

int
file_unlock(fd)
	int	fd;
{
#ifdef hpux
	(void) lockf(fd, F_ULOCK);
#else
	(void) flock(fd, LOCK_UN);
#endif
}
