/*
 * disassoc.c
 *
 * boilerplate daemon code; disassociate from
 * the current tty by forking, closing all file
 * descriptors, opening slash, and ioctl-ing
 * TIOCNOTTY
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/file.h>

disassoc()
{
	int	i;

	if (fork() != 0)
		bye_bye(0);
	for (i = 0; i < 10; i++)
		(void) close(i);
	(void) open("/", O_RDONLY, 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
#ifndef hpux
	i = open("/dev/tty", O_RDWR, 0);
	if (i > 0) {
		(void) ioctl(i, TIOCNOTTY, 0);
		(void) close(i);
	}
#endif
}
