#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/gen/RCS/chance.c,v 1.6 89/05/10 03:54:00 muir Exp $";
#endif

/*
 * chance.c
 *
 * return 1 if "roll" is under the chance
 *
 * from PSL Empire, 1985
 */

int
chance(d)
	double	d;
{
	double	roll;

	roll = (random() & 0x7fff);
	if (d >= roll/32768.0)
		return 1;
	return 0;
}

/*
 * round value to nearest int (on the average). E.g. rounds up
 * with a chance proportional to the size of the fractional part.
 */
int
roundavg(val)
	double	val;
{
	int	flr;

	flr = (int) val;
	if (val < 0)
		flr -= chance(flr - val);
	else
		flr += chance(val - flr);
	return flr;
}

#ifdef hpux
srandom(n)
	long	n;
{
	srand(n);
}

long
random()
{
	extern	long rand();

	return (rand() >> 8);
}
#endif
