static char *RCSid = "$Header: empmod.c,v 1.14 89/02/08 17:40:22 muir Locked $";

/*
 * empmod.c
 *
 * Command/function mapping for empire.  Named empmod for historical
 * reasons -- empire used to be broken into seven modules
 * on the venerable pdp 11 so it could fit in 64k I/D space.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "com.h"
#include "nat.h"
#include "tm.h"
#include "file.h"

#ifdef notdef
extern	int  add();
extern	int assa();
extern	int atta();
extern	int boar();
extern	int buil();
extern	int chan();
extern	int coas();
extern	int coll();
extern	int comm();
extern	int cons();
extern	int coun();
extern	int decl();
extern	int deli();
extern	int demo();
extern	int show();
extern	int desi();
extern	int diss();
extern	int enli();
extern	int fire();
extern	int flee();
extern	int  fly();
extern	int info();
extern	int ledg();
extern	int load();
extern	int look();
extern	int  map();
extern	int mine();
extern  int move();
extern	int nati();
extern	int navi();
extern  int head(), news();
extern	int nuke();
extern	int offe();
extern	int offs();
extern	int powe();
extern	int rada();
extern	int  rea();
extern	int real();
extern	int repa();
extern	int rout();
extern	int  set();
extern	int  spy();
extern	int tele();
extern	int tend();
extern	int torp();
extern	int trad();
extern  int tran();
extern	int trea();
extern	int turn();
extern	int vers();
extern  int weat(), fore();
/*
 * new commands
 */
extern	int buy();
extern	int sell();
extern	int mult();
extern	int repo();
extern	int fina();
extern	int laun();
extern	int new();
extern	int shoo();
extern	int thre();
extern	int dist();
extern	int sct();
extern	int plan();
extern	int arm();
extern	int hard();
extern	int upgr();
extern	int surv();
extern	int capi();
extern	int orig();
extern	int mark();
extern	int conv();
extern  int leve();
extern	int cuto();
extern	int prod();
extern	int  wai();
extern	int carg();
extern	int terr();
extern	int sate();
extern	int give();
extern	int edit();
extern	int wipe();
extern	int wing();

#else

extern	int head();
extern	int news();
extern	int desi();
extern	int  map();
extern	int cens();
extern	int  shi();
extern	int buil();
extern	int give();
extern	int nati();
extern	int  rea();
extern	int move();
extern	int tran();
extern	int  new();
extern	int  add();
extern	int tele();
extern	int nuke();
extern	int real();
extern	int comm();

extern	int explain();
extern	int quit();

#define	 assa	0
#define	 atta	0
#define	 boar	0
#define	 chan	0
#define	 coas	0
#define	 coll	0
#define	 cons	0
#define	 coun	0
#define	 decl	0
#define	 deli	0
#define	 demo	0
#define	 show	0
#define	 diss	0
#define	 enli	0
#define	 fire	0
#define	 flee	0
#define	  fly	0
#define	 info	0
#define	 ledg	0
#define	 load	0
#define	 look	0
#define	 mine	0
#define	 navi	0
#define	 offe	0
#define	 offs	0
#define	 powe	0
#define	 rada	0
#define	 repa	0
#define	 rout	0
#define	  set	0
#define	  spy	0
#define	 tend	0
#define	 torp	0
#define	 trad	0
#define	 trea	0
#define	 turn	0
#define	 vers	0
#define  weat	0
#define	fore	0

#define	 buy	0
#define	 sell	0
#define	 mult	0
#define	 repo	0
#define	 fina	0
#define	 laun	0
#define	 shoo	0
#define	 thre	0
#define	 dist	0
#define	 sct	0
#define	 plan	0
#define	 arm	0
#define	 hard	0
#define	 upgr	0
#define	 surv	0
#define	 capi	0
#define	 orig	0
#define	 mark	0
#define	 conv	0
#define  leve	0
#define	 cuto	0
#define	 prod	0
#define	  wai	0
#define	 carg	0
#define	 terr	0
#define	 sate	0
#define	 edit	0
#define	 wipe	0
#define	 wing	0

#endif

#define	SCT	bit(EF_SECTOR)
#define SHP	bit(EF_SHIP)
#define PLN	bit(EF_PLANE)

struct  comstr  coms[]  = {
/* command form                       cost lck    addr  permit */
"add {a new country}",                  0, SCT,   add,  GOD,
"announce",                             1, 0,    tele,  NORM,
"arm <PLANE> <WARHEAD> <NUMBER>",       3, SCT,   arm,  NORM+MONEY,
"assault <SECT> {from ship}",           3, SCT|SHP,assa,NORM+MONEY,
"attack <SECT> <move-in> {from sect}",  3, SCT,  atta,  NORM+MONEY+CAP,
"board <SHIP> {from ship}",             3, SHP,  boar,  NORM+MONEY,
"build <UNIT-TYPE> <SECTS> <type>",     1, SHP|SCT,buil,NORM+MONEY+CAP,
"buy <COMMODITY>",                      1, SCT,   buy,  NORM+MONEY+CAP,
"bye {log-off}",                        0, 0,    quit,  VIS,
"capitol <SECTOR>",                     1, 0,    capi,  NORM,
"cargo {report on} <SHIP/FLEET>",       0, 0,    carg,  NORM,
"census {on} <SECTS>",                  0, 0,    cens,  NORM,
"change country|representative",        0, 0,    chan,  NORM,
"coastwatch {from} <SECTS>",            1, 0,    coas,  NORM,
"collect {on} <LOAN>",                  2, 0,    coll,  NORM+CAP,
"commodity {report} <SECTS>",           0, 0,    comm,  NORM,
"consider loan|treaty <NUM>",           1, 0,    cons,  NORM+CAP,
"convert <SECTS> <NUM>",                2, 0,    conv,  NORM+CAP,
"country roster",                       0, 0,    coun,  GOD,
"cutoff {del level report} <SECTS>",    0, 0,    cuto,  NORM,
"declare alliance|neutrality|hostility|war <CNUM/CNAME>",2,0,decl,NORM,
"deliver <ITEM> <SECTS> [[+|-]thresh]", 1, SCT,  deli,  NORM,
"demobilize <SECTS>",                   1, SCT,  demo,  NORM+MONEY,
"designate <SECTS>",                    1, SCT,  desi,  NORM,
"dissolve {government}",                0, SCT|SHP,diss,NORM,
"distribute <COMMODITY> <SECTS>",       1, SCT,  dist,  NORM,
"edit country|land|ship|plane|nuke",	2, 0,	  edit,  GOD,
"enlist {in} <SECTS>",                  2, SCT,  enli,  NORM+MONEY+CAP,
"financial {report}",                   1, 0,    fina,  NORM+MONEY,
"fire {on} <SECT> | <SHIP>",            1, SCT|SHP,fire,NORM+MONEY,
"fleetadd <FLEET> <SHIP/FLEET>",        1, SHP,  flee,  NORM,
"fly {mission from} <SECT> | <SHIP>",   2, SCT|SHP,fly, NORM+MONEY,
"forecast {weather in} <SECTS>",        1, 0,    fore,  NORM,
"give commodity|land|ship|plane|nuke",	2, 0,	  give,  GOD,
"harden <MISSILE> <LEVEL>",             2, SCT,  hard,  NORM+MONEY,
"headlines [days] {from \"news\"}",     0, 0,    head,  VIS,
"info {on} <topic>",                    0, 0,    info,  VIS,
"launch <SHIP>",                        3, SCT|SHP,laun,NORM+MONEY,
"ledger {loan report}",                 0, 0,    ledg,  NORM,
"level {report} <SECTS>",               0, 0,    leve,  NORM,
"list of commands",                     0, 0,    explain,VIS,
"load <SHIP/FLEET>",                    1, SHP|SCT,load,NORM,
"lookout {from} <SHIP/FLEET>",          1, 0,    look,  NORM,
"market {commodity trading report}",    0, 0,    mark,  NORM,
"map {from} <SECT>",                    0, 0,    map,   NORM,
"mine {from} <SHIP>",                   2, SCT|SHP,mine,NORM+MONEY,
"move c|m|s|g|p|i|o|b|f|r|u",           1, SCT,  move,  NORM+CAP,
"mult",                                 1, 0,    mult,  NORM,
"nation {report}",                      0, 0,    nati,  NORM,
"navigate <SHIP/FLEET>",                1, SHP,  navi,  NORM,
"newcap <CNUM/CNAME>",                  0, SCT,   new,  GOD,
"newspaper [days]",                     0, 0,    news,  VIS,
"nuke {report} <SECTS>",                0, 0,    nuke,  NORM+CAP,
"offer loan|treaty <CNUM/CNAME>",       1, 0,    offe,  NORM,
"offset {capital} <x> <y>",             0, 0,    offs,  GOD,
"origin <SECTOR>",                      1, 0,    orig,  NORM,
"plane <SECTS>",                        0, 0,    plan,  NORM,
"power {report}",                       0, 0,    powe,  VIS,
"production {report} <SECTS>",          0, 0,    prod,  NORM,
"quit {end a session}",                 0, 0,    quit,  VIS,
"radar <SHIP/FLEET> | <SECTS>",         1, 0,    rada,  NORM,
"read telegrams",                       0, 0,    rea,   VIS,
"realm <number> [<SECTS>]",             0, 0,    real,  NORM,
"repay <LOAN>",                         1, 0,    repa,  NORM,
"repo {on nation levels}",              0, 0,    repo,  VIS,
"route {delivery} <ITEM> <SECTS>",      1, 0,    rout,  NORM+CAP,
"satellite <SECTS>",                    1, 0,    sate,  NORM,
"sect <SECTS>",                         0, 0,    sct,   NORM,
"sell <SECTS> <COMMODITY> <NUMBER>",    1, SCT,  sell,  NORM,
"set {price} <SHIP/FLEET> | <SECTS>",   1, SHP,  set,   NORM,
"ship {report on} <SHIP/FLEET>",        0, 0,    shi,   NORM,
"shoot <SECTS> <NUMBER>",               3, SCT,  shoo,  NORM+CAP,
"show <UNIT-TYPE> [build|cap]",		0, 0,	  show,	 VIS,
"spy {on} <SECTS>",                     1, SCT,  spy,   NORM+CAP,
"survey <WHAT> <SECTS>",                0, 0,    surv,  NORM+CAP,
"telegram {to} <CNUM/CNAME>",           0, 0,    tele,  NORM,
"tend <SHIP> <COMM> <AMT> <SHIP/FLEET>",1, SHP,  tend,  NORM+MONEY,
"territory <SECTS> <NUMBER>",		1, SCT,  terr,  NORM,
"threshold <COMM> <SECTS> <THRESH>",    1, SCT,  thre,  NORM,
"torpedo <SHIP>",                       3, SHP,  torp,  NORM+MONEY,
"trade {report}",                       1, SHP,  trad,  NORM,
"transport <NUKE>",                     1, SCT|SHP,tran,NORM+CAP,
"treaty report",                        0, 0,    trea,  NORM,
"turn {the game} on|off|mess",          0, 0,    turn,  GOD,
"unload <SHIP/FLEET>",                  1, SHP|SCT,load,NORM,
"upgrade <SHIP/FLEET>",                 1, SHP,  upgr,  NORM+MONEY,
"version {identification}",             0, 0,    vers,  VIS,
"wait {for telegrams}",                 0, 0,     wai,  NORM,
"weather {map for} <SECTS>",            0, 0,    weat,  NORM,
"wingadd <WING> <PLANE/WING>",          1, PLN,  wing,  NORM,
"wipe ,SECTS>",				1, SCT,  wipe,  NORM,
0,					0, 0,       0,  0,
};
