static char *RCSid = "$Header: empdis.c,v 1.5 88/09/03 18:34:43 muir Locked $";

/*
 * empdis.c
 *
 * empire dispatcher stuff
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "defs.h"
#include "com.h"
#include "sailio.h"
#include "deity.h"
#include "keyword.h"
#include "file.h"

#include <setjmp.h>
#include <sys/file.h>
#include <sys/time.h>
#include <signal.h>

int
getcommand(combufp)
	char	*combufp;
{
	struct	natstr *natp;
	char	prompt[40];
	char	buf2[512];

	natp = getnatp(cnum);
	strcpy(prompt, fmt("%d %d", natp->nat_minused, natp->nat_btu));
	do { 
		outid(C_PROMPT);
		putc('\n', stdout);
		if (prmptrd(prompt, buf2, sizeof(buf2)) == 0)
			return -1;
	} while (*buf2 == 0);
	copy(buf2, combufp);
	return (strlen(combufp));
}

init_files()
{
	extern	int commf;
	extern	char upfil[];
	extern	char commfil[];
	extern	char hoursfil[];
	int	upf;
	struct	telstr tgm;
	char	buf[512];
	FILE	*fp;

	if (fp = fopen(hoursfil, "r")) {
		kw_read(fp);
		fclose(fp);
	}
	/* open the rest of the empire files */
	ef_open(EF_NATION, O_RDONLY, EFF_MEM);
	ef_open(EF_SECTOR, O_RDWR, 0);
	ef_open(EF_NEWS, O_RDWR, 0);
	ef_open(EF_LOAN, O_RDWR, 0);
	ef_open(EF_SHIP, O_RDWR, 0);
	ef_open(EF_PLANE, O_RDWR, 0);
	ef_open(EF_TREATY, O_RDWR, 0);
	ef_open(EF_NUKE, O_RDWR, 0);
	ef_open(EF_TRADE, O_RDWR, 0);
	commf = open(commfil, O_RDWR, 0);
	if ((upf = open(upfil, O_RDONLY, 0)) < 0)
		return;
	if (read(upf, (char *) &tgm, sizeof(tgm)) != sizeof(tgm))
		return;
	if (read(upf, buf, tgm.tel_length) != tgm.tel_length)
		return;
	if (tgm.tel_length >= sizeof(buf)) {
		buf[tgm.tel_length-1] = 0;
		pr(buf);
		(void) close(upf);
	}
}

explain()
{
	register char *format;
	register int i;
	register int two_per;

	pr("\t\tCurrent EMPIRE Command List\n");
	pr("\t\t------- ------ ------- ----\n");
	pr("Initial number is cost in B.T.U. units.\n");
	pr("Text enclosed in {braces} is comment");
	pr(" rather than part of the command.\n");
	pr("Args in [brackets] are optional,");
	pr(" but can only appear on the command line.\n");
	if (nstat > 4) {
		pr("Args in <angle brackets>");
		pr(" have the following meanings:\n");
		pr("  <CNUM/CNAME> :: a country number or name\n");
		pr("  <ITEM> :: commodity such as `ore', `guns', etc\n");
		pr("  <LOAN> :: loan number\n");
		pr("  <SECT> :: sector coordinates in the form:   x,y\n");
		pr("  <SECTS> :: sector(s) in the form:");
		pr("   lox:hix,loy:hiy/d ?cond&cond&...  \n");
		pr("  <SHIP> :: one ship number\n");
		pr("  <FLEET> :: fleet designation, or area\n");
	}
	two_per = 0;
	for (i = 0; (format = coms[i].c_form) != 0; i++) {
		if ((coms[i].c_permit & ncomstat) == coms[i].c_permit) {
			two_per ^= 1;
			if (two_per == 0)
				pr(fmt("%d %s\n", coms[i].c_cost, format));
			else
				pr(fmt("%d %-34.34s", coms[i].c_cost, format));
		}
	}
	if (two_per != 0)
		pr("\n");
	pr("For further info on command syntax see \"info syntax\".\n");
	return RET_OK;
}

/*
 * returns true if down
 */
int
gamedown()
{
	extern	char downfil[];
	int	tmp;

	if (god)
		return 0;
	if ((tmp = open(downfil, O_RDONLY, 0)) < 0)
		return 0;
	pr("The game is down\n");
	(void) close(tmp);
	return 1;
}

daychange(now)
	time_t	now;
{
	struct	natstr *natp;
	struct	tm *tm;

	natp = getnatp(cnum);
	tm = localtime(&now);
	if ((tm->tm_yday % 128) != natp->nat_dayno) {
		NAT_SET(nat_dayno, cnum, tm->tm_yday % 128);
		NAT_SET(nat_minused, cnum, 0);
		tm_sync(5000);
	}
}

/*
 * returns true if game can be played now.
 * Sets the number of minutes until the hours
 * function must be re-called.
 */
int
gamehours(now)
	time_t	now;
{
	extern	char hoursfil[];
	extern	char *kw_find();
	extern	struct tm *localtime();
	extern	int m_m_p_d;
	extern	int timeleft;
	register char *bp;
	register struct tm *tm;
	FILE	*fp;
	int	day;
	int	hour[2];
	int	curtime;
	int	okday[7];
	int	tomorrow;
	int	minleft;
	struct	natstr *natp;
	int	n;

	tm = localtime(&now);
	natp = getnatp(cnum);
	if ((fp = fopen(hoursfil, "r")) == 0) {
		minleft = min(m_m_p_d - natp->nat_minused,
			tm->tm_hour*60 + tm->tm_min);
		return 1;
	}
	kw_read(fp);
	fclose(fp);
	curtime = tm->tm_min * 60 + tm->tm_hour;
	if (bp = kw_find("days")) {
		for (day=0; day<7; day++)
			okday[day] = 0;
		while (bp = kw_parse(CF_WEEKDAY, bp, &day))
			okday[day] = 1;
	} else {
		for (day=0; day<7; day++)
			okday[day] = 1;
	}
	if (!okday[tm->tm_wday])
		return 0;
	if (bp = kw_find("hours")) {
		while (bp = kw_parse(CF_TIMERANGE, bp, hour))
			if (curtime >= hour[0] && curtime < hour[1])
				break;
		if (bp == 0)
			return 0;
	} else {
		hour[0] = 0;
		hour[1] = 24*60;
	}
	tomorrow = tm->tm_wday + 1;
	if (tomorrow >= 7)
		tomorrow = 0;
	if (bp = kw_find("minutes"))
		kw_parse(CF_VALUE, bp, &m_m_p_d);
	minleft = m_m_p_d - natp->nat_minused;
	n = 60*24 - (tm->tm_min + tm->tm_hour*60);
	if (n < minleft)
		minleft = n;
	n = hour[1] - curtime;
	if (n < minleft)
		minleft = n;
	return 1;
}

char   *
chk(buf, value)
	register char *buf;
	int     value;
{
	register int start;
	register int end;

	if (*buf == ':') {
		buf++;
		return buf;
	}
	start = end = atoi(buf);
	while (*buf != 0 && *buf != '-' && *buf != ':')
		buf++;
	if (*buf++ == '-') {
		end = atoi(buf);
		while (*buf != 0)
			if (*buf++ == ':')
				break;
	}
	if (value < start || value > end)
		return 0;
	return buf;
}

/*
 * This is DANGEROUS.  Signals in empire should
 * be stamped out entirely!  If a signal comes in
 * during a malloc, for example, the game will be
 * well-hosed.
 */
catch(sig_num)
	int     sig_num;
{
	extern	jmp_buf env;

	signal(sig_num, catch);
	longjmp(env, 1);
}

bye_bye(code)
	int	code;
{
	extern	SAIL *iop;

	if (iop != 0) {
		NAT_DELTA(nat_login, cnum, -1);
		sflush(iop);
	}
	(void) outid(C_EXIT);
	puts("so long...");
	(void) fflush(stdout);
	exit(code);
}
