#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/xy.c,v 1.2 89/05/10 04:04:21 muir Exp $";
#endif

/*
 * xy.c
 *
 * x-y related conversion routines.
 *
 * Dave Pare, 1989
 */

#include <ctype.h>
#include "misc.h"
#include "xy.h"
#include "nat.h"
#include "sect.h"
#include "deity.h"
#include "file.h"

/*
 * return pointer to a string containing the x,y
 * coords as desired by a particular target country.
 */
char *
xyas(x, y, country)
	coord	x;
	coord	y;
	int	country;
{
	static	char buf[4][20];
	static	int nbuf = -1;
	struct	natstr *np;

	if (++nbuf > 3)
		nbuf = 0;
	np = getnatp(country);
	sprintf(buf[nbuf], "%d,%d", xrel(np, x), yrel(np, y));
	return buf[nbuf];
}

char *
ownxy(sp) 
	struct sctstr *sp;
{
	return xyas(sp->sct_x, sp->sct_y, sp->sct_own);
}

coord
xrel(np, absx)
	struct	natstr *np;
	coord	absx;
{
	coord	x;

	if ((np->nat_stat & STAT_ABS) == 0) {
		x = xnorm(absx - np->nat_xorg);
	} else {
		x = xnorm(absx);
	}
	if (x >= WORLD_X/2)
		x -= WORLD_X;
	else if (x < -WORLD_X/2)
		x += WORLD_X;
	return x;
}

coord
yrel(np, absy)
	struct	natstr *np;
	coord	absy;
{
	coord	y;

	if ((np->nat_stat & STAT_ABS) == 0) {
		y = ynorm(absy - np->nat_yorg);
	} else {
		y = ynorm(absy);
	}
	if (y >= WORLD_Y/2)
		y -= WORLD_Y;
	else if (y < -WORLD_Y/2)
		y += WORLD_Y;
	return y;
}

inputxy(xp, yp, cn)
	coord	*xp;
	coord	*yp;
	int	cn;
{
	struct	natstr *np;

	np = getnatp(cn);
	*xp = xabs(np, *xp);
	*yp = yabs(np, *yp);
}

coord
xabs(np, relx)
	struct	natstr *np;
	coord	relx;
{
	if ((np->nat_stat & STAT_ABS) == 0)
		relx += np->nat_xorg;
	return xnorm(relx);
}

coord
yabs(np, rely)
	struct	natstr *np;
	coord	rely;
{
	if ((np->nat_stat & STAT_ABS) == 0)
		rely += np->nat_yorg;
	return ynorm(rely);
}

int
sctoff(x, y)
	coord	x;
	coord	y;
{
	return (ynorm(y) * WORLD_X + xnorm(x))/2;
}

coord
xnorm(x)
	register coord x;
{
	if (x < 0)
		x = WORLD_X - (-x % WORLD_X);
	return x % WORLD_X;
}

coord
ynorm(y)
	register coord y;
{
	if (y < 0)
		y = WORLD_Y - (-y % WORLD_Y);
	return y % WORLD_Y;
}
