#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/vlist.c,v 1.2 89/05/10 04:04:19 muir Exp $";
#endif

/*
 * vlist.c
 *
 * manage variable lists
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "product.h"

int
vl_find(vtype, typevec, amtvec, nelem)
	register int vtype;
	u_char	*typevec;
	short	*amtvec;
	int	nelem;
{
	register u_char *vp;
	register short *ap;
	register u_char *endp;

	if (vtype < 0 || vtype > V_MAX)
		return -1;
	vp = typevec;
	ap = amtvec;
	endp = vp + nelem;
	for ( ; vp < endp; vp++, ap++) {
		if (*vp == vtype)
			return *ap;
	}
	return 0;
}

int
vl_set(vtype, amt, typevec, amtvec, nvp, max)
	register int vtype;
	int	amt;
	u_char	*typevec;
	short	*amtvec;
	u_char	*nvp;
	int	max;
{
	register u_char *vp;
	register u_char *endp;
	register short *ap;
	int	n;

	if (vtype < 0 || vtype > V_MAX)
		return -1;
	vp = typevec;
	ap = amtvec;
	endp = vp + *nvp;
	if (amt < 0)
		amt = 0;
	else if (amt > 32767)
		amt = 32767;
	for ( ; vp < endp; vp++, ap++) {
		if (*vp == vtype)
			break;
	}
	if (vp == endp) {
		if (amt == 0) {
			/* deleting, but not present */
			return 0;
		}
		if (*nvp == max) {
			if (isdel(vtype) || isdist(vtype))
				return -1;
			/* replace any del or dst entries */
			if ((n = freeslot(typevec, endp)) < 0)
				return -1;
			vp = &typevec[n];
			ap = &amtvec[n];
		} else {
			/* add at end */
			(*nvp)++;
		}
		*vp = vtype;
		*ap = amt;
	} else {
		if (amt != 0) {
			/* altering; just change value */
			*ap = amt;
			return amt;
		}
		(*nvp)--;
		if (vp < endp-1) {
			/* if not last element, copy last to current */
			*ap = amtvec[*nvp];
			*vp = typevec[*nvp];
		}
	}
	return amt;
}

int
vl_damage(pct, typevec, amtvec, nelem)
	register int pct;
	register u_char *typevec;
	register short *amtvec;
	register int nelem;
{
	register int i;
	register int lose100;
	register int lose;

	if (pct >= 100 || pct <= 0)
		return 0;
	for (i=0; i<nelem; i++) {
		if (!isitem(typevec[i]))
			continue;
		lose100 = amtvec[i] * pct;
		lose = lose100 / 100;
		if (chance((lose100 % 100) * 0.01))
			lose++;
		if ((amtvec[i] -= lose) == 0) {
			nelem--;
			if (i == nelem)
				break;
			typevec[i] = typevec[nelem];
			amtvec[i] = amtvec[nelem];
			i--;
		}
	}
	return nelem;
}

/*
 * extract all "mask" items from the variable list
 * caller must pass a pointer to an aray of I_MAX+1,
 * or else bad things will happen.
 */
int
vl_getvec(src_type, src_amt, src_nv, mask, dst_amt)
	register u_char *src_type;
	register short *src_amt;
	register int src_nv;
	register int mask;
	register int dst_amt[I_MAX+1];
{
	register int n;
	int	count;

	for (n=0; n<I_MAX+1; n++)
		dst_amt[n] = 0;
	for (count=0, n=0; n<src_nv; n++) {
		if ((src_type[n] & mask) != mask)
			continue;
		dst_amt[src_type[n] & ~VT_TYPE] = src_amt[n];
		count++;
	}
	return count;
}

/*
 * Copy the vec into the variable list.  All items zero in
 * the vec will be deleted from the vlist, and all items
 * present in the vec will be added to the vlist.
 */
int
vl_setvec(type, amt, nvp, max, mask, vec)
	register u_char *type;
	register short *amt;
	u_char	*nvp;
	int	max;
	register int mask;
	register int *vec;
{
	register int nv;
	register int n;
	register int vec_n;

	nv = *nvp;
	vec_n = 1;
	for (n=0; n<nv; n++) {
		if ((type[n] & mask) != mask)
			continue;
		/* find non-zero vec entry */
		for ( ; vec_n <= I_MAX; vec_n++)
			if (vec[vec_n] != 0)
				break;
		if (vec_n > I_MAX) {
			nv--;
			if (n < nv) {
				type[n] = type[nv];
				amt[n] = amt[nv];
			}
		} else {
			type[n] = V_ITEM(vec_n);
			amt[n] = vec[vec_n];
			vec_n++;
		}
	}
	/* free slots at end; copy rest of vec into the vlist */
	while (vec_n <= I_MAX && nv < max) {
		type[nv] = V_ITEM(vec_n);
		amt[nv] = vec[vec_n];
		nv++;
	}
	*nvp = nv;
	if (mask == VT_ITEM || mask == VT_COND) {
		/*
		 * still stuff left; make free slots out of deliveries
		 * and distributes and stuff 'em in (only for item or cond)
		 */
		for ( ; vec_n <= I_MAX; vec_n++) {
			if (vec[vec_n] == 0)
				continue;
			if ((n = freeslot(type, &type[max])) < 0) {
				logerror("vl_setvec: no free slots left\n");
				return 0;
			}
			type[n] = V_ITEM(vec_n);
			amt[n] = vec[vec_n];
			vec_n++;
		}
	}
	return 1;
}

/*
 * make a free slot; deliveries and distributions
 * are fair game for us.
 */
static
int
freeslot(vec, end)
	u_char	*vec;
	register u_char *end;
{
	register u_char *vp;

	for (vp=vec; vp < end; vp++) {
		if (isdel(*vp) || isdist(*vp))
			return vp - vec;
	}
	return -1;
}
