#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/nat.c,v 1.1 89/05/10 03:56:19 muir Exp $";
#endif

/*
 * nat.c
 *
 * misc accesses on the nation file,
 * just associated with the in-memory copy.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

char *
cname(n)
	int	n;
{
	struct	natstr *np;

	if ((np = getnatp(n)) == 0)
		return 0;
	return np->nat_cnam;
}

char *
relatename(np, other)
	struct	natstr *np;
	int	other;
{
	extern	char *relates[];

	return relates[getrel(np, other)];
}

char *
natstate(np)
	struct	natstr *np;
{
	if ((np->nat_stat & STAT_INUSE) == 0)
		return "FREE";
	if (np->nat_stat & STAT_GOD)
		return "DEITY";
	if ((np->nat_stat & STAT_NORM) == 0)
		return "VISITOR";
	return "ACTIVE";
}

int
getrel(np, them)
	struct	natstr *np;
	int	them;
{
	int	ind;
	int	shift;
	int	relate;

	ind = them / 8;
	shift = 14 - ((them - ((them / 8) << 3)) * 2);
	relate = (np->nat_relate[ind] >> shift) & 03;
	return relate;
}

putrel(np, them, relate)
	struct	natstr *np;
	int	them;
	int	relate;
{
	int	shift;
	int	newrel;
	int	ind;

	relate &= 03;
	ind = them / 8;
	shift = 14 - ((them - ((them / 8) << 3)) * 2);
	newrel = np->nat_relate[ind];
	newrel &= ~(03 << shift);
	newrel |= (relate << shift);
	np->nat_relate[ind] = newrel;
}
