
#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/getvar.c,v 1.8 89/05/10 04:04:14 muir Exp $";
#endif

/*
 * getvar.c
 *
 * getvar/putvar/getvec just call the vl_get/set/getvec code.
 * Used for manipulating variable lists.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"

int
getvar(vtype, sp, ptype)
	int	vtype;
	char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	short	*vamtp;
	u_char	*nvp;

	if (ef_vars(ptype, sp, &nvp, &vtypep, &vamtp) < 0)
		return -1;
	return vl_find(vtype, vtypep, vamtp, (int) *nvp);
}

int
getvec(mask, sp, ptype, vec)
	int	mask;
	char	*sp;
	int	ptype;
	int	*vec;
{
	u_char	*vtypep;
	short	*vamtp;
	u_char	*nvp;

	if (ef_vars(ptype, sp, &nvp, &vtypep, &vamtp) < 0)
		return -1;
	return vl_getvec(vtypep, vamtp, (int)*nvp, mask, vec);
}

int
putvar(vtype, amt, sp, ptype)
	int	vtype;
	int	amt;
	char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	short	*vamtp;
	u_char	*nvp;
	int	maxv;

	if (vtype < 0 || vtype > V_MAX)
		return -1;
	if ((maxv = ef_vars(ptype, sp, &nvp, &vtypep, &vamtp)) < 0)
		return -1;
	if (amt < 0)
		amt = 0;
	else if (amt > 32767)
		amt = 32767;
	return vl_set(vtype, amt, vtypep, vamtp, nvp, maxv);
}

int
putvec(mask, vec, sp, ptype)
	int	mask;
	int	*vec;
	char	*sp;
	int	ptype;
{
	u_char	*vtypep;
	short	*vamtp;
	u_char	*nvp;
	int	maxv;

	if ((maxv = ef_vars(ptype, sp, &nvp, &vtypep, &vamtp)) < 0)
		return -1;
	return vl_setvec(vtypep, vamtp, nvp, maxv, mask, vec);
}
