#ifndef lint
static char *RCSid = "$Header: /usr6/postgres/muir/empire/empmain/common/RCS/damage.c,v 1.5 89/05/10 03:55:57 muir Exp $";
#endif

/*
 * damage.c
 *
 * damage a sector, ship, or plane.
 *
 * Should probably do this in some regular fashion, but
 * we don't yet have a list of fields we can iterate through
 * and find the "damageable" ones.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "nuke.h"

sectdamage(sp, dam)
	register struct sctstr *sp;
	int	dam;
{
	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;
	sp->sct_effic = damage((int)sp->sct_effic, dam);
	sp->sct_mobil = damage((int)sp->sct_mobil, dam);
	sp->sct_nv = vl_damage(dam, sp->sct_vtype, sp->sct_vamt,
		(int)sp->sct_nv);
	if (sp->sct_effic < 20 && sp->sct_type == SCT_BHEAD)
		bridgefall(sp);
}

shipdamage(sp, dam)
	struct	shpstr *sp;
	int	dam;
{
	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;
	sp->shp_effic = damage((int)sp->shp_effic, dam);
	sp->shp_mobil = damage((int)sp->shp_mobil, dam);
	sp->shp_nv = vl_damage(dam, sp->shp_vtype, sp->shp_vamt,
		(int) sp->shp_nv);
}

planedamage(pp, dam)
	struct	plnstr *pp;
	int	dam;
{
	if (dam <= 0)
		return;
	if (dam > 100)
		dam = 100;
	pp->pln_effic = damage((int)pp->pln_effic, dam);
	pp->pln_mobil = damage((int)pp->pln_mobil, dam);
}

/*
 * nukedamage() actually just calculates damage
 * rather than inflicting it.
 */
int
nukedamage(ncp, range, airburst)
	struct	nchrstr *ncp;
	int	range;
	int	airburst;
{
	int	dam;
	int	rad;

	rad = ncp->n_blast;
	if (airburst)
		rad *= 1.5;
	if (rad < range)
		return 0;
	if (airburst) {
		/* larger area, less center damage */
		dam = (ncp->n_dam * 0.75) - (range * 20);
	} else {
		/* smaller area, more center damage */
		dam = (ncp->n_dam / (range + 1.0));
	}
	if (dam < 5)
		dam = 0;
	return dam;
}

int
damage(amt, pct)
	register int amt;
	int	pct;
{
	register int tmp;
	register int lost;

	if (amt <= 0)
		return 0;
	tmp = amt * pct;
	lost = tmp / 100;
	if ((random() % 100) < (tmp % 100))
		lost++;
	return amt - lost;
}
